/*
 * Copyright (C) 2005-2015 Schlichtherle IT Services.
 * All rights reserved. Use is subject to license terms.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.inst.InstrumentingCompositeDriver;
import de.schlichtherle.truezip.fs.inst.InstrumentingController;
import de.schlichtherle.truezip.fs.inst.InstrumentingDirector;
import de.schlichtherle.truezip.fs.inst.InstrumentingManager;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import javax.annotation.concurrent.Immutable;

/**
 * @author Christian Schlichtherle
 */
@Immutable
public final class JulDirector extends InstrumentingDirector<JulDirector> {
    public static final JulDirector SINGLETON = new JulDirector();

    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE
            ? SocketFactory.NIO
            : SocketFactory.OIO;

    private JulDirector() { }

    @Override
    public <E extends IOPool.Entry<E>> IOPool<E> instrument(IOPool<E> pool) {
        return new JulIOPool<E>(pool, this);
    }

    @Override
    public FsController<?> instrument(FsController<?> controller, InstrumentingManager context) {
        return controller;
    }

    @Override
    public FsController<?> instrument(FsController<?> controller, InstrumentingCompositeDriver context) {
        return new InstrumentingController<JulDirector>(controller, this);
    }

    @Override
    protected <E extends Entry> InputSocket<E> instrument(InputSocket<E> input) {
        return SOCKET_FACTORY.newInputSocket(input, this);
    }

    @Override
    protected <E extends Entry> OutputSocket<E> instrument(OutputSocket<E> output) {
        return SOCKET_FACTORY.newOutputSocket(output, this);
    }

    private enum SocketFactory {
        NIO() {
            @Override
            <E extends Entry> InputSocket<E> newInputSocket(
                    InputSocket<E> input, JulDirector director) {
                return new JulNio2InputSocket<E>(input, director);
            }

            @Override
            <E extends Entry> OutputSocket<E> newOutputSocket(
                    OutputSocket<E> output, JulDirector director) {
                return new JulNio2OutputSocket<E>(output, director);
            }
        },
        
        OIO() {
            @Override
            <E extends Entry> InputSocket<E> newInputSocket(
                    InputSocket<E> input, JulDirector director) {
                return new JulInputSocket<E>(input, director);
            }

            @Override
            <E extends Entry> OutputSocket<E> newOutputSocket(
                    OutputSocket<E> output, JulDirector director) {
                return new JulOutputSocket<E>(output, director);
            }
        };
        
        abstract <E extends Entry> InputSocket<E> newInputSocket(
                InputSocket<E> input, JulDirector director);

        abstract <E extends Entry> OutputSocket<E> newOutputSocket(
                OutputSocket<E> output, JulDirector director);
    }
}
