/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jul.NeverThrowable;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JulInputStream<E extends Entry>
extends DecoratingInputStream {
    private static final Logger logger = Logger.getLogger(JulInputStream.class.getName());
    private final Entry target;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    JulInputStream(InputSocket<?> socket) throws IOException {
        this(socket, (Entry)socket.getLocalTarget());
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private JulInputStream(InputSocket<?> socket, Entry target) throws IOException {
        super(socket.newInputStream());
        this.target = target;
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Stream reading " + target, new NeverThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (Throwable throwable) {
            Level level = this.target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
            logger.log(level, "Closed " + this.target, new NeverThrowable());
            throw throwable;
        }
        Level level = this.target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Closed " + this.target, new NeverThrowable());
    }
}

