/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsSimpleCompositeDriver;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.inst.jmx.JmxModelViewMXBean;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

final class JmxModelView
extends StandardMBean
implements JmxModelViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static final FsCompositeDriver DRIVER = new FsSimpleCompositeDriver((FsDriverProvider)FsDriverLocator.SINGLETON);
    private final FsModel model;
    private volatile FsController<?> parentController;
    private volatile FsEntryName parentEntryName;

    static JmxModelViewMXBean register(FsModel model) {
        ObjectName name = JmxModelView.getObjectName(model);
        JmxModelView view = new JmxModelView(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxModelViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(FsModel model) {
        ObjectName name = JmxModelView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(FsModel model) {
        String path = model.getMountPoint().toHierarchicalUri().toString();
        try {
            return new ObjectName(FsModel.class.getName(), "path", ObjectName.quote(path));
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxModelView(FsModel model) {
        super(JmxModelViewMXBean.class, true);
        this.model = model;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A file system model.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        String description = null;
        if (name.equals("MountPoint")) {
            description = "The mount point URI of this file system.";
        } else if (name.equals("Mounted")) {
            description = "Whether or not this file system needs to get sync()ed.";
        } else if (name.equals("ParentMountPoint")) {
            description = "The mount point URI of the parent file system.";
        } else if (name.equals("SizeOfData")) {
            description = "The data size of this file system.";
        } else if (name.equals("SizeOfStorage")) {
            description = "The storage size of this file system.";
        } else if (name.equals("TimeWritten")) {
            description = "The last write time of this file system.";
        } else if (name.equals("TimeRead")) {
            description = "The last read or access time of this file system.";
        } else if (name.equals("TimeCreated")) {
            description = "The creation time of this file system.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("sync")) {
            description = "Synchronizes this file system and all enclosed file systems. If any file system is busy with I/O, an FsSyncException is thrown.";
        }
        return description;
    }

    @Override
    public String getMountPoint() {
        return this.model.getMountPoint().toString();
    }

    @Override
    public boolean isMounted() {
        return this.model.isMounted();
    }

    @Override
    public String getParentMountPoint() {
        FsModel parent = this.model.getParent();
        assert (null != parent);
        return parent.getMountPoint().toString();
    }

    private FsController<?> getParentController() {
        FsController parentController = this.parentController;
        return null != parentController ? parentController : (this.parentController = FsManagerLocator.SINGLETON.get().getController(this.model.getMountPoint(), DRIVER).getParent());
    }

    private FsEntryName getParentEntryName() {
        FsEntryName parentEntryName = this.parentEntryName;
        return null != parentEntryName ? parentEntryName : (this.parentEntryName = this.model.getMountPoint().getPath().getEntryName());
    }

    @Override
    public long getSizeOfData() {
        try {
            return this.getParentController().getEntry(this.getParentEntryName()).getSize(Entry.Size.DATA);
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public long getSizeOfStorage() {
        try {
            return this.getParentController().getEntry(this.getParentEntryName()).getSize(Entry.Size.STORAGE);
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public String getTimeWritten() {
        long time;
        try {
            time = this.getParentController().getEntry(this.getParentEntryName()).getTime(Entry.Access.WRITE);
        }
        catch (IOException ex) {
            return null;
        }
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeRead() {
        long time;
        try {
            time = this.getParentController().getEntry(this.getParentEntryName()).getTime(Entry.Access.READ);
        }
        catch (IOException ex) {
            return null;
        }
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeCreated() {
        long time;
        try {
            time = this.getParentController().getEntry(this.getParentEntryName()).getTime(Entry.Access.CREATE);
        }
        catch (IOException ex) {
            return null;
        }
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public void sync() throws FsSyncException {
        new FsFilteringManager(FsManagerLocator.SINGLETON.get(), this.model.getMountPoint()).sync(FsSyncOptions.NONE);
    }
}

