/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jul.JulOutputSocket;
import de.schlichtherle.truezip.fs.inst.jul.NeverThrowable;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
final class JulOutputStream<E extends Entry>
extends DecoratingOutputStream {
    private static final Logger logger = Logger.getLogger(JulOutputStream.class.getName());
    private final JulOutputSocket<E> socket;

    JulOutputStream(OutputStream model, JulOutputSocket<E> socket) throws IOException {
        super(model);
        if (null == model) {
            throw new NullPointerException();
        }
        this.socket = socket;
        Entry target = socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Stream writing " + target, new NeverThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (Throwable throwable) {
            Entry target = this.socket.getLocalTarget();
            Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
            logger.log(level, "Closed " + target, new NeverThrowable());
            throw throwable;
        }
        Entry target = this.socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Closed " + target, new NeverThrowable());
    }
}

