/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jul.JulNio2InputSocket;
import de.schlichtherle.truezip.fs.inst.jul.NeverThrowable;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
final class JulInputByteChannel<E extends Entry>
extends DecoratingSeekableByteChannel {
    private static final Logger logger = Logger.getLogger(JulInputByteChannel.class.getName());
    private final JulNio2InputSocket<E> socket;

    JulInputByteChannel(SeekableByteChannel model, JulNio2InputSocket<E> socket) throws IOException {
        super(model);
        if (null == model) {
            throw new NullPointerException();
        }
        this.socket = socket;
        Entry target = socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Randomly reading " + target, new NeverThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (Throwable throwable) {
            Entry target = this.socket.getLocalTarget();
            Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
            logger.log(level, "Closed " + target, new NeverThrowable());
            throw throwable;
        }
        Entry target = this.socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Closed " + target, new NeverThrowable());
    }
}

