/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.fs.inst.InstrumentingIOPool;
import de.schlichtherle.truezip.fs.inst.jul.JulDirector;
import de.schlichtherle.truezip.fs.inst.jul.NeverThrowable;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
final class JulIOPool<E extends IOPool.Entry<E>>
extends InstrumentingIOPool<E> {
    private static final Logger logger = Logger.getLogger(JulIOPool.class.getName());

    JulIOPool(IOPool<E> model, JulDirector director) {
        super(model, director);
    }

    @Override
    public IOPool.Entry<E> allocate() throws IOException {
        return new LogEntry((IOPool.Entry)this.delegate.allocate());
    }

    private final class LogEntry
    extends InstrumentingIOPool.InstrumentingEntry {
        LogEntry(IOPool.Entry<E> model) {
            super(model);
            logger.log(Level.FINE, "Allocated " + this.delegate, new NeverThrowable());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws IOException {
            try {
                ((IOPool.Entry)this.delegate).release();
            }
            finally {
                logger.log(Level.FINE, "Released " + this.delegate, new NeverThrowable());
            }
        }
    }
}

