/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class JmxInputStream
extends DecoratingInputStream {
    private final JmxIOStatistics stats;

    JmxInputStream(InputStream in, JmxIOStatistics stats) {
        super(in);
        assert (null != stats);
        this.stats = stats;
    }

    public int read() throws IOException {
        int ret = this.delegate.read();
        if (0 < ret) {
            this.stats.incBytesRead(1);
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.delegate.read(b, off, len);
        if (0 < ret) {
            this.stats.incBytesRead(ret);
        }
        return ret;
    }
}

