/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.http.HttpController;
import de.schlichtherle.truezip.fs.http.HttpInputSocket;
import de.schlichtherle.truezip.fs.http.HttpOutputSocket;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
final class HttpEntry
extends FsEntry
implements IOEntry<HttpEntry> {
    private static final BitField<FsOutputOption> NO_OUTPUT_OPTIONS = BitField.noneOf(FsOutputOption.class);
    private final String name;
    private final URL url;
    private HttpController controller;
    @CheckForNull
    private volatile URLConnection connection;

    HttpEntry(FsMountPoint mountPoint, FsEntryName name, HttpController controller) {
        this.name = name.toString();
        try {
            this.url = mountPoint.resolve(name).toUri().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        assert (null != controller);
        this.controller = controller;
    }

    HttpController getController() {
        return this.controller;
    }

    URL getUrl() {
        return this.url;
    }

    URLConnection getConnection() throws IOException {
        URLConnection connection = this.connection;
        return null != connection ? connection : (this.connection = this.url.openConnection());
    }

    public String getName() {
        return this.name;
    }

    public Set<Entry.Type> getTypes() {
        try {
            this.getConnection();
            return FILE_TYPE_SET;
        }
        catch (IOException failure) {
            return Collections.EMPTY_SET;
        }
    }

    public boolean isType(Entry.Type type) {
        if (Entry.Type.FILE != type) {
            return false;
        }
        try {
            this.getConnection();
            return true;
        }
        catch (IOException failure) {
            return false;
        }
    }

    public long getSize(Entry.Size type) {
        try {
            if (Entry.Size.DATA == type) {
                return this.getConnection().getContentLength();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    public long getTime(Entry.Access type) {
        try {
            if (Entry.Access.WRITE == type) {
                return this.getConnection().getLastModified();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Nullable
    public Set<String> getMembers() {
        return null;
    }

    public InputSocket<HttpEntry> getInputSocket() {
        return new HttpInputSocket(this);
    }

    public OutputSocket<HttpEntry> getOutputSocket() {
        return new HttpOutputSocket(this, NO_OUTPUT_OPTIONS, null);
    }

    public OutputSocket<HttpEntry> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new HttpOutputSocket(this, options, template);
    }
}

