/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.http.HttpDriver;
import de.schlichtherle.truezip.fs.http.HttpEntry;
import de.schlichtherle.truezip.fs.http.ReadOnlyFileSystemTypeException;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class HttpController
extends FsController<FsModel> {
    private final HttpDriver driver;
    private final FsModel model;

    HttpController(FsModel model, HttpDriver driver) {
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        assert (null != driver);
        this.driver = driver;
        this.model = model;
    }

    public FsModel getModel() {
        return this.model;
    }

    HttpDriver getDriver() {
        return this.driver;
    }

    public FsController<?> getParent() {
        return null;
    }

    public Icon getOpenIcon() throws IOException {
        return null;
    }

    public Icon getClosedIcon() throws IOException {
        return null;
    }

    public boolean isReadOnly() throws IOException {
        return false;
    }

    public HttpEntry getEntry(FsEntryName name) throws IOException {
        HttpEntry entry = new HttpEntry(this.model.getMountPoint(), name, this);
        return null != entry.getType() ? entry : null;
    }

    public boolean isReadable(FsEntryName name) throws IOException {
        return null != this.getEntry(name);
    }

    public boolean isWritable(FsEntryName name) throws IOException {
        return false;
    }

    public void setReadOnly(FsEntryName name) throws IOException {
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new HttpEntry(this.model.getMountPoint(), name, this).getInputSocket();
    }

    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new HttpEntry(this.model.getMountPoint(), name, this).getOutputSocket(options, template);
    }

    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    public void unlink(FsEntryName name) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
    }
}

