/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.lambdadecor;

import de.schlegel11.lambdadecor.DecorPair;
import de.schlegel11.lambdadecor.Unappliable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Behaviour<T> {
    @SafeVarargs
    public static <T> Behaviour<T> withAll(Behaviour<T> behaviour, Function<T, T> ... functions) {
        Objects.requireNonNull(behaviour, "Behaviour argument \"updateBehaviour\" in \"withAll(updateBehaviour, ...)\" is null.");
        Objects.requireNonNull(functions, "Varags \"functions\" in \"withAll(..., functions)\" is null.");
        return behaviour.withAll(Arrays.stream(functions));
    }

    @SafeVarargs
    public static <T> Behaviour<T> withUnapplyAll(Behaviour<T> behaviour, Function<T, Unappliable> ... functions) {
        Objects.requireNonNull(behaviour, "Behaviour argument \"updateBehaviour\" in \"withUnapplyAll(updateBehaviour, ...)\" is null.");
        Objects.requireNonNull(functions, "Varags \"functions\" in \"withUnapplyAll(..., functions)\" is null.");
        return behaviour.withUnapplyAll(Arrays.stream(functions));
    }

    @SafeVarargs
    public static <T> Behaviour<T> mergeAll(Behaviour<T> behaviour, Behaviour<T> ... behaviours) {
        Objects.requireNonNull(behaviour, "Behaviour argument \"updateBehaviour\" in \"mergeAll(updateBehaviour, ...)\" is null.");
        Objects.requireNonNull(behaviours, "Varags \"behaviours\" in \"mergeAll(..., behaviours)\" is null.");
        return behaviour.mergeAll(Arrays.stream(behaviours));
    }

    public Behaviour<T> with(Function<T, T> var1);

    default public Behaviour<T> withAll(Stream<Function<T, T>> functionStream) {
        Objects.requireNonNull(functionStream, "Stream argument \"functionStream\" in \"withAll(functionStream)\" is null.");
        return this.with(functionStream.map(f -> Objects.requireNonNull(f, "Stream argument \"functionStream\" in \"withAll(functionStream)\" contains null.")).reduce(Function::andThen).orElse(Function.identity()));
    }

    public Behaviour<T> withUnapply(Function<T, Unappliable> var1);

    default public Behaviour<T> withUnapplyAll(Stream<Function<T, Unappliable>> functionStream) {
        Objects.requireNonNull(functionStream, "Stream argument \"functionStream\" in \"withUnapplyAll(functionStream)\" is null.");
        Behaviour<T> behaviour = this;
        for (Function f : functionStream.collect(Collectors.toList())) {
            behaviour = behaviour.withUnapply(f);
        }
        return behaviour;
    }

    public Behaviour<T> merge(Behaviour<T> var1);

    default public Behaviour<T> mergeAll(Stream<Behaviour<T>> behaviourStream) {
        Objects.requireNonNull(behaviourStream, "Stream argument \"behaviourStream\" in \"mergeAll(behaviourStream)\" is null.");
        return behaviourStream.reduce(this, Behaviour::merge);
    }

    public DecorPair<T> apply(T var1);
}

