/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.lambdadecor;

import de.schlegel11.lambdadecor.Behaviour;
import de.schlegel11.lambdadecor.DecorPair;
import de.schlegel11.lambdadecor.DefaultBehaviour;
import de.schlegel11.lambdadecor.LambdaDecor;
import de.schlegel11.lambdadecor.Unappliable;
import java.util.Objects;
import java.util.function.Function;

public class DefaultLambdaDecor<T>
implements LambdaDecor<T> {
    private Behaviour<T> behaviour;
    private Unappliable unappliable = Unappliable.EMPTY;

    private DefaultLambdaDecor(Behaviour<T> behaviour) {
        this.behaviour = Objects.requireNonNull(behaviour, "Behaviour argument \"updateBehaviour\" for initialisation is null.");
    }

    public static <T> LambdaDecor<T> create(Behaviour<T> behaviour) {
        return new DefaultLambdaDecor<T>(behaviour);
    }

    public static <T> LambdaDecor<T> create() {
        return DefaultLambdaDecor.create(DefaultBehaviour.newBehaviour());
    }

    @Override
    public void updateBehaviour(Function<Behaviour<T>, Behaviour<T>> behaviourFunction) {
        Objects.requireNonNull(behaviourFunction, "Function argument \"behaviourFunction\" in \"updateBehaviour(behaviourFunction)\" is null.");
        this.behaviour = Objects.requireNonNull(behaviourFunction.apply(this.behaviour), "Behaviour is null.");
    }

    @Override
    public T apply(T type) {
        DecorPair<T> pair = this.behaviour.apply(type);
        this.unappliable = pair._Unapply;
        return pair._Behaviour;
    }

    @Override
    public void unapply() {
        this.unappliable.unapply();
    }
}

