/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.lambdadecor;

import de.schlegel11.lambdadecor.Behaviour;
import de.schlegel11.lambdadecor.DecorPair;
import de.schlegel11.lambdadecor.Unappliable;
import java.util.Objects;
import java.util.function.Function;

public class DefaultBehaviour<T>
implements Behaviour<T> {
    private final Function<DecorPair<T>, DecorPair<T>> behaviour;

    private DefaultBehaviour() {
        this(Function.identity());
    }

    private DefaultBehaviour(Function<DecorPair<T>, DecorPair<T>> behaviour) {
        this.behaviour = Objects.requireNonNull(behaviour, "Behaviour is null.");
    }

    public static <T> Behaviour<T> newBehaviour(Function<Behaviour<T>, Behaviour<T>> function) {
        Objects.requireNonNull(function, "Function is null.");
        return function.apply(DefaultBehaviour.newBehaviour());
    }

    public static <T> Behaviour<T> newBehaviour() {
        return new DefaultBehaviour<T>();
    }

    @Override
    public final Behaviour<T> withUnapply(Function<T, Unappliable> function) {
        Objects.requireNonNull(function, "Function is null.");
        return new DefaultBehaviour<T>(this.behaviour.andThen(t -> t.updateUnapply(u -> u.andThen((Unappliable)function.apply(t._Behaviour)))));
    }

    @Override
    public final Behaviour<T> with(Function<T, T> function) {
        Objects.requireNonNull(function, "Function is null.");
        return new DefaultBehaviour<T>(this.behaviour.andThen(t -> t.updateBehaviour(function.apply(t._Behaviour))));
    }

    @Override
    public final Behaviour<T> merge(Behaviour<T> other) {
        Objects.requireNonNull(other, "Behaviour is null.");
        return new DefaultBehaviour<T>(this.behaviour.andThen(p -> {
            DecorPair pair = other.apply(p._Behaviour);
            return p.updateBehaviour(pair._Behaviour).updateUnapply(u -> u.andThen(pair._Unapply));
        }));
    }

    @Override
    public final DecorPair<T> apply(T type) {
        return this.behaviour.apply(DecorPair.create(type, Unappliable.EMPTY));
    }
}

