/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.jfxanimation;

import de.schlegel11.jfxanimation.ConditionalInterpolator;
import de.schlegel11.jfxanimation.JFXAnimationTemplate;
import de.schlegel11.jfxanimation.JFXAnimationTemplateAction;
import de.schlegel11.jfxanimation.JFXAnimationTemplateConfig;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.util.Duration;

public class JFXAnimationTemplates {
    public static <N> Timeline buildTimeline(JFXAnimationTemplate<N> creator) {
        Timeline timeline = new Timeline();
        JFXAnimationTemplateConfig creatorConfig = creator.buildAndGetTemplateConfig();
        creator.buildAndGetAnimationValues().forEach((percent, animationValues) -> {
            Duration percentageDuration = creatorConfig.getDuration().multiply(percent / 100.0);
            KeyValue[] keyValues = (KeyValue[])animationValues.stream().flatMap(animationValue -> animationValue.mapTo(JFXAnimationTemplates.createKeyValue(creatorConfig.getInterpolator(), animationValue))).toArray(KeyValue[]::new);
            Consumer onFinish = animationValues.stream().map(animationValue -> actionEvent -> {
                if (animationValue.isExecuted()) {
                    animationValue.handleOnFinish((ActionEvent)actionEvent);
                    animationValue.addExecution(1);
                }
            }).reduce(action -> {}, Consumer::andThen);
            KeyFrame keyFrame = new KeyFrame(percentageDuration, onFinish::accept, keyValues);
            timeline.getKeyFrames().add((Object)keyFrame);
        });
        timeline.setAutoReverse(creatorConfig.isAutoReverse());
        timeline.setCycleCount(creatorConfig.getCycleCount());
        timeline.setDelay(creatorConfig.getDelay());
        timeline.setRate(creatorConfig.getRate());
        timeline.setOnFinished(creatorConfig::handleOnFinish);
        return timeline;
    }

    private static Function<WritableValue<Object>, KeyValue> createKeyValue(Interpolator globalInterpolator, JFXAnimationTemplateAction<?, ?> animationValue) {
        return writableValue -> {
            Interpolator interpolator = animationValue.getInterpolator().orElse(globalInterpolator);
            return new KeyValue(writableValue, animationValue.getEndValue(), (Interpolator)new ConditionalInterpolator(interpolator, (WritableValue<Object>)writableValue, animationValue::isExecuted));
        };
    }
}

