/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.jfxanimation;

import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.util.Duration;

public class JFXAnimationTemplateConfig {
    private final Supplier<Duration> durationSupplier;
    private final Supplier<Integer> cycleCountSupplier;
    private final Supplier<Boolean> autoReverseSupplier;
    private final Supplier<Interpolator> interpolatorSupplier;
    private final Supplier<Duration> delaySupplier;
    private final Supplier<Double> rateSupplier;
    private final EventHandler<ActionEvent> onFinish;

    private JFXAnimationTemplateConfig(Builder builder) {
        this.durationSupplier = builder.durationSupplier;
        this.cycleCountSupplier = builder.cycleCountSupplier;
        this.autoReverseSupplier = builder.autoReverseSupplier;
        this.interpolatorSupplier = builder.interpolatorSupplier;
        this.delaySupplier = builder.delaySupplier;
        this.rateSupplier = builder.rateSupplier;
        this.onFinish = builder.onFinish;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Duration getDuration() {
        return this.durationSupplier.get();
    }

    public int getCycleCount() {
        return this.cycleCountSupplier.get();
    }

    public boolean isAutoReverse() {
        return this.autoReverseSupplier.get();
    }

    public Interpolator getInterpolator() {
        return this.interpolatorSupplier.get();
    }

    public Duration getDelay() {
        return this.delaySupplier.get();
    }

    public double getRate() {
        return this.rateSupplier.get();
    }

    public void handleOnFinish(ActionEvent actionEvent) {
        this.onFinish.handle((Event)actionEvent);
    }

    public static final class Builder {
        private Supplier<Duration> durationSupplier = () -> Duration.seconds((double)1.0);
        private Supplier<Integer> cycleCountSupplier = () -> 1;
        private Supplier<Boolean> autoReverseSupplier = () -> false;
        private Supplier<Interpolator> interpolatorSupplier = () -> Interpolator.LINEAR;
        private Supplier<Duration> delaySupplier = () -> Duration.ZERO;
        private Supplier<Double> rateSupplier = () -> 1.0;
        private EventHandler<ActionEvent> onFinish = event -> {};

        private Builder() {
        }

        public Builder duration(Duration duration) {
            return this.duration(() -> duration);
        }

        public Builder duration(Supplier<Duration> durationSupplier) {
            this.durationSupplier = durationSupplier;
            return this;
        }

        public Builder cycleCount(int cycleCount) {
            return this.cycleCount(() -> cycleCount);
        }

        public Builder cycleCount(Supplier<Integer> cycleCountSupplier) {
            this.cycleCountSupplier = cycleCountSupplier;
            return this;
        }

        public Builder infiniteCycle() {
            return this.cycleCount(-1);
        }

        public Builder autoReverse(boolean reverse) {
            return this.autoReverse(() -> reverse);
        }

        public Builder autoReverse(Supplier<Boolean> reverseSupplier) {
            this.autoReverseSupplier = reverseSupplier;
            return this;
        }

        public Builder interpolator(Interpolator interpolator) {
            return this.interpolator(() -> interpolator);
        }

        public Builder interpolator(Supplier<Interpolator> interpolatorSupplier) {
            this.interpolatorSupplier = interpolatorSupplier;
            return this;
        }

        public Builder delay(Duration delay) {
            return this.delay(() -> delay);
        }

        public Builder delay(Supplier<Duration> delaySupplier) {
            this.delaySupplier = delaySupplier;
            return this;
        }

        public Builder rate(double rate) {
            return this.rate(() -> rate);
        }

        public Builder rate(Supplier<Double> rateSupplier) {
            this.rateSupplier = rateSupplier;
            return this;
        }

        public Builder onFinish(EventHandler<ActionEvent> onFinish) {
            this.onFinish = onFinish;
            return this;
        }

        public JFXAnimationTemplateConfig build() {
            return new JFXAnimationTemplateConfig(this);
        }
    }
}

