/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.jfxanimation;

import de.schlegel11.jfxanimation.JFXAnimationTemplateAction;
import de.schlegel11.jfxanimation.JFXAnimationTemplateConfig;
import de.schlegel11.jfxanimation.JFXAnimationTemplates;
import de.schlegel11.jfxanimation.JFXTemplateAction;
import de.schlegel11.jfxanimation.JFXTemplateBuilder;
import de.schlegel11.jfxanimation.JFXTemplateConfig;
import de.schlegel11.jfxanimation.JFXTemplateProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.Timeline;
import javafx.scene.Node;

public class JFXAnimationTemplate<N>
implements JFXTemplateConfig<N>,
JFXTemplateBuilder<N> {
    private static final String NO_KEY_FOUND_MESSAGE = "No animation objects with key \"%s\" found.\nPlease check your build method where the namedAnimationObjects are defined or your withAnimationObject methods where the keys are accessed.";
    private final Set<Double> percents = new HashSet<Double>();
    private final Map<Double, List<Function<JFXAnimationTemplateAction.InitBuilder<N>, JFXAnimationTemplateAction.Builder<?, ?>>>> creatorValueBuilderFunctions = new HashMap();
    private final Class<N> animationObjectType;
    private Map<String, Collection<Object>> animationObjects;
    private Function<JFXAnimationTemplateConfig.Builder, JFXAnimationTemplateConfig.Builder> creatorConfigBuilderFunction;
    private boolean clearPercents;

    private JFXAnimationTemplate(Class<N> animationObjectType) {
        this.animationObjectType = animationObjectType;
    }

    public static <N> JFXTemplateProcess<N> create(Class<N> animationObjectType) {
        return new JFXAnimationTemplate<N>(animationObjectType);
    }

    public static JFXTemplateProcess<Node> create() {
        return JFXAnimationTemplate.create(Node.class);
    }

    public Map<Double, List<JFXAnimationTemplateAction<?, ?>>> buildAndGetAnimationValues() {
        HashMap animationValueMap = new HashMap();
        this.creatorValueBuilderFunctions.forEach((percent, animationValueBuilderFunctions) -> {
            List animationValues = animationValueBuilderFunctions.stream().flatMap(builderFunction -> ((JFXAnimationTemplateAction.Builder)builderFunction.apply(JFXAnimationTemplateAction.builder(this.animationObjectType))).buildActions(this::getAnimationObjectsWithKeys)).collect(Collectors.toList());
            animationValueMap.put((Double)percent, (List<JFXAnimationTemplateAction<?, ?>>)animationValues);
        });
        return animationValueMap;
    }

    private List<Object> getAnimationObjectsWithKeys(Collection<String> keys) {
        ArrayList<Object> animationObjectList = new ArrayList<Object>();
        for (String key : keys) {
            Collection<Object> animationObjectsPerKey = this.animationObjects.get(key);
            if (animationObjectsPerKey == null) {
                throw new NoSuchElementException(String.format(NO_KEY_FOUND_MESSAGE, key));
            }
            animationObjectList.addAll(animationObjectsPerKey);
        }
        return animationObjectList;
    }

    public JFXAnimationTemplateConfig buildAndGetTemplateConfig() {
        return this.creatorConfigBuilderFunction.apply(JFXAnimationTemplateConfig.builder()).build();
    }

    @Override
    public JFXTemplateAction<N> percent(double first, double ... rest) {
        if (this.clearPercents) {
            this.percents.clear();
            this.clearPercents = false;
        }
        this.percents.add(Math.max(0.0, Math.min(100.0, first)));
        this.creatorValueBuilderFunctions.put(first, new ArrayList());
        for (double percent : rest) {
            this.percents.add(Math.max(0.0, Math.min(100.0, percent)));
            this.creatorValueBuilderFunctions.put(percent, new ArrayList());
        }
        return this;
    }

    @Override
    public JFXTemplateAction<N> from() {
        return this.percent(0.0, new double[0]);
    }

    @Override
    public JFXTemplateAction<N> to() {
        return this.percent(100.0, new double[0]);
    }

    @Override
    public JFXTemplateConfig<N> action(Function<JFXAnimationTemplateAction.InitBuilder<N>, JFXAnimationTemplateAction.Builder<?, ?>> valueBuilderFunction) {
        for (Double percent : this.percents) {
            this.creatorValueBuilderFunctions.get(percent).add(valueBuilderFunction);
        }
        this.clearPercents = true;
        return this;
    }

    @Override
    public JFXTemplateConfig<N> action(JFXAnimationTemplateAction.Builder<?, ?> animationValueBuilder) {
        return this.action((JFXAnimationTemplateAction.InitBuilder<N> builder) -> animationValueBuilder);
    }

    @Override
    public JFXTemplateBuilder<N> config(Function<JFXAnimationTemplateConfig.Builder, JFXAnimationTemplateConfig.Builder> configBuilderFunction) {
        this.creatorConfigBuilderFunction = configBuilderFunction;
        return this;
    }

    @Override
    public JFXTemplateBuilder<N> config(JFXAnimationTemplateConfig.Builder configBuilder) {
        return this.config((JFXAnimationTemplateConfig.Builder builder) -> configBuilder);
    }

    @Override
    public <B> B build(Function<JFXAnimationTemplate<N>, B> builderFunction, Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>, JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>> mapBuilderFunction) {
        this.animationObjects = mapBuilderFunction.apply(JFXTemplateBuilder.JFXAnimationObjectMapBuilder.builder()).getAnimationObjects();
        this.animationObjects.putIfAbsent("_DefaultName_", Collections.singletonList(null));
        return builderFunction.apply(this);
    }

    @Override
    public <B> B build(Function<JFXAnimationTemplate<N>, B> builderFunction, N defaultAnimationObject) {
        return this.build(builderFunction, (N)((Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder, JFXTemplateBuilder.JFXAnimationObjectMapBuilder>)b -> b.defaultObject(defaultAnimationObject, new Object[0])));
    }

    @Override
    public Timeline build(Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>, JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>> mapBuilderFunction) {
        return this.build((Function)JFXAnimationTemplates::buildTimeline, (N)mapBuilderFunction);
    }

    @Override
    public Timeline build(N defaultAnimationObject) {
        return this.build((N)((Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder, JFXTemplateBuilder.JFXAnimationObjectMapBuilder>)b -> b.defaultObject(defaultAnimationObject, new Object[0])));
    }

    @Override
    public Timeline build() {
        return this.build((N)Function.identity());
    }
}

