/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.eventdispatcher;

import com.google.common.collect.Sets;
import de.schlegel11.eventdispatcher.EventListenerWrapper;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

final class EventDispatcherList {
    public static final EventDispatcherList PSEUDO_EMPTY_DISPATCHER_LIST = new EventDispatcherList();
    private final Set<EventListenerWrapper> listeners = Sets.newHashSet();

    EventDispatcherList() {
    }

    public boolean addListener(EventListener listener, int numberOfCalls) {
        return this.listeners.add(new EventListenerWrapper(listener, numberOfCalls));
    }

    public boolean removeListener(EventListener listener) {
        return this.listeners.removeIf(elw -> elw.getListener() == listener);
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public int getListenerMaxCalls(EventListener listener) {
        EventListenerWrapper elw = this.getElw(listener);
        return elw.getMaxCalls();
    }

    public int getListenerCurrentCalls(EventListener listener) {
        EventListenerWrapper elw = this.getElw(listener);
        return elw.getCurrentCalls();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireEvent(Consumer<EventListener> consumer) {
        for (EventListenerWrapper elw2 : this.listeners) {
            elw2.addCurrentCalls(elw2.getMaxCalls() == -1 ? 0 : 1);
            consumer.accept(elw2.getListener());
        }
        this.listeners.removeIf(elw -> elw.getMaxCalls() == elw.getCurrentCalls());
    }

    public int hashCode() {
        return Objects.hash(this.listeners);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventDispatcherList other = (EventDispatcherList)obj;
        return Objects.equals(this.listeners, other.listeners);
    }

    private EventListenerWrapper getElw(EventListener listener) {
        Stream<EventListenerWrapper> stream = this.listeners.stream().filter(elw -> elw.getListener() == listener);
        return stream.findFirst().orElse(EventListenerWrapper.DUMMY_ELW);
    }
}

