/*
 * Decompiled with CFR 0.152.
 */
package de.schlegel11.eventdispatcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import de.schlegel11.eventdispatcher.EventDispatcherList;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class EventDispatcher {
    private static final String IS_NULL = "Argument is null.";
    private static final String ARGUMENT_MAX_CALLS = "Argument is less or equal 0 (except -1).";
    private final Map<Class<? extends EventListener>, EventDispatcherList> dispatchers = Maps.newHashMap();

    private EventDispatcher() {
    }

    public static EventDispatcher newInstance() {
        return new EventDispatcher();
    }

    public boolean addListener(Class<? extends EventListener> clazz, EventListener listener) {
        return this.addListener(clazz, listener, -1);
    }

    public boolean addListener(Class<? extends EventListener> clazz, EventListener listener, int maxCalls) {
        Objects.requireNonNull(clazz, IS_NULL);
        Objects.requireNonNull(listener, IS_NULL);
        Preconditions.checkArgument((maxCalls > 0 || maxCalls == -1 ? 1 : 0) != 0, (Object)ARGUMENT_MAX_CALLS);
        return this.dispatchers.computeIfAbsent(clazz, v -> new EventDispatcherList()).addListener(listener, maxCalls);
    }

    public boolean removeListener(Class<? extends EventListener> clazz, EventListener listener) {
        EventDispatcherList edl = this.dispatchers.getOrDefault(clazz, EventDispatcherList.PSEUDO_EMPTY_DISPATCHER_LIST);
        boolean result = edl.removeListener(listener);
        if (edl.isEmpty()) {
            this.removeListenerType(clazz);
        }
        return result;
    }

    public boolean removeListenerType(Class<? extends EventListener> clazz) {
        return Objects.nonNull(this.dispatchers.remove(clazz));
    }

    public void clear() {
        this.dispatchers.clear();
    }

    public int getListenerCount() {
        return this.dispatchers.keySet().stream().mapToInt(this::getListenerCount).sum();
    }

    public int getListenerCount(Class<? extends EventListener> clazz) {
        return this.dispatchers.getOrDefault(clazz, EventDispatcherList.PSEUDO_EMPTY_DISPATCHER_LIST).getListenerCount();
    }

    public int getListenerTypeCount() {
        return this.dispatchers.size();
    }

    public int getListenerMaxCalls(Class<? extends EventListener> clazz, EventListener listener) {
        return this.dispatchers.getOrDefault(clazz, EventDispatcherList.PSEUDO_EMPTY_DISPATCHER_LIST).getListenerMaxCalls(listener);
    }

    public int getListenerCurrentCalls(Class<? extends EventListener> clazz, EventListener listener) {
        return this.dispatchers.getOrDefault(clazz, EventDispatcherList.PSEUDO_EMPTY_DISPATCHER_LIST).getListenerCurrentCalls(listener);
    }

    public <T extends EventListener> boolean fireEvent(Class<T> clazz, Consumer<T> consumer) {
        EventDispatcherList edl = this.dispatchers.get(clazz);
        if (Objects.nonNull(edl) && Objects.nonNull(consumer)) {
            edl.fireEvent(consumer);
            if (edl.isEmpty()) {
                this.removeListenerType(clazz);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dispatchers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventDispatcher other = (EventDispatcher)obj;
        return Objects.equals(this.dispatchers, other.dispatchers);
    }
}

