/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.metamodel.ListPropertyMetaDataStore;
import de.saxsys.synchronizefx.core.metamodel.SilentChangeExecutor;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListPropertyCommandExecutor;
import java.util.List;

public class SimpleListPropertyCommandExecutor
implements ListPropertyCommandExecutor {
    private final WeakObjectRegistry objectRegistry;
    private final SilentChangeExecutor silentChangeExecutor;
    private final ValueMapper valueMapper;
    private final ListPropertyMetaDataStore listMetaData;

    public SimpleListPropertyCommandExecutor(WeakObjectRegistry objectRegistry, SilentChangeExecutor silentChangeExecutor, ValueMapper valueMapper, ListPropertyMetaDataStore listVersions) {
        this.objectRegistry = objectRegistry;
        this.silentChangeExecutor = silentChangeExecutor;
        this.valueMapper = valueMapper;
        this.listMetaData = listVersions;
    }

    @Override
    public void execute(final AddToList command) {
        final List<Object> list = this.getListOrFail(command);
        final Object value = this.valueMapper.map(command.getValue());
        this.silentChangeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                list.add(command.getPosition(), value);
            }
        });
        this.updateVersion(command);
    }

    @Override
    public void execute(final RemoveFromList command) {
        final List<Object> list = this.getListOrFail(command);
        this.silentChangeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                int position = command.getStartPosition();
                int count = command.getRemoveCount();
                if (position == 0 && list.size() == count) {
                    list.clear();
                } else {
                    for (int i = 0; i < count; ++i) {
                        list.remove(position);
                    }
                }
            }
        });
        this.updateVersion(command);
    }

    @Override
    public void execute(final ReplaceInList command) {
        final List<Object> list = this.getListOrFail(command);
        this.silentChangeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                list.set(command.getPosition(), SimpleListPropertyCommandExecutor.this.valueMapper.map(command.getValue()));
            }
        });
        this.updateVersion(command);
    }

    private void updateVersion(ListCommand command) {
        this.listMetaData.getMetaDataOrFail(command.getListId()).setLocalVersion(command.getListVersionChange().getToVersion());
    }

    private List<Object> getListOrFail(ListCommand command) {
        return (List)this.objectRegistry.getByIdOrFail(command.getListId());
    }
}

