/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.metamodel.ListPropertyMetaDataStore;
import de.saxsys.synchronizefx.core.metamodel.TemporaryReferenceKeeper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.commands.Value;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListPropertyCommandExecutor;
import java.util.UUID;

public class ListPropertyCommandFilter
implements ListPropertyCommandExecutor {
    private final ListPropertyCommandExecutor executor;
    private final TemporaryReferenceKeeper referenceKeeper;
    private final ListPropertyMetaDataStore listVersions;
    private final WeakObjectRegistry objectRegistry;
    private final boolean useLocalVerision;

    public ListPropertyCommandFilter(ListPropertyCommandExecutor executor, TemporaryReferenceKeeper referenceKeeper, ListPropertyMetaDataStore listVersions, WeakObjectRegistry objectRegistry, boolean useLocalVerision) {
        this.executor = executor;
        this.referenceKeeper = referenceKeeper;
        this.listVersions = listVersions;
        this.objectRegistry = objectRegistry;
        this.useLocalVerision = useLocalVerision;
    }

    @Override
    public void execute(AddToList command) {
        this.referenceKeeper.cleanReferenceCache();
        if (this.couldBeExecuted(command)) {
            this.executor.execute(command);
        } else {
            this.keepReferenceIfObservable(command.getValue());
        }
    }

    @Override
    public void execute(RemoveFromList command) {
        this.referenceKeeper.cleanReferenceCache();
        if (this.couldBeExecuted(command)) {
            this.executor.execute(command);
        }
    }

    @Override
    public void execute(ReplaceInList command) {
        this.referenceKeeper.cleanReferenceCache();
        if (this.couldBeExecuted(command)) {
            this.executor.execute(command);
        } else {
            this.keepReferenceIfObservable(command.getValue());
        }
    }

    private boolean couldBeExecuted(ListCommand command) {
        ListPropertyMetaDataStore.ListPropertyMetaData metaData = this.listVersions.getMetaDataOrFail(command.getListId());
        UUID listVersion = this.useLocalVerision ? metaData.getLocalVersion() : metaData.getApprovedVersion();
        UUID commandFromVersion = command.getListVersionChange().getFromVersion();
        return commandFromVersion.equals(listVersion);
    }

    private void keepReferenceIfObservable(Value value) {
        if (value.isSimpleObject()) {
            return;
        }
        this.referenceKeeper.keepReferenceTo(this.objectRegistry.getByIdOrFail(value.getObservableObjectId()));
    }
}

