/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.UUID;

public class ListCommandVersionRepairer {
    public void repairLocalCommandsVersion(Queue<ListCommand> localCommands, ListCommand originalRemoteCommand) {
        localCommands.add(this.repairCommand(localCommands.poll(), originalRemoteCommand.getListVersionChange().getToVersion(), UUID.randomUUID()));
        int count = localCommands.size();
        for (int i = 1; i < count; ++i) {
            localCommands.add(this.repairCommand(localCommands.poll(), UUID.randomUUID(), UUID.randomUUID()));
        }
    }

    public List<? extends ListCommand> repairRemoteCommandVersion(List<? extends ListCommand> indexRepairedRemoteCommands, List<ListCommand> versionRepairedLocalCommands) {
        int commandCount = indexRepairedRemoteCommands.size();
        ListCommand lastLocalCommand = versionRepairedLocalCommands.get(versionRepairedLocalCommands.size() - 1);
        if (commandCount == 0) {
            return Arrays.asList(new RemoveFromList(lastLocalCommand.getListId(), new ListCommand.ListVersionChange(UUID.randomUUID(), lastLocalCommand.getListVersionChange().getToVersion()), 0, 0));
        }
        ArrayList<ListCommand> repaired = new ArrayList<ListCommand>(commandCount);
        for (int i = 0; i < commandCount - 1; ++i) {
            repaired.add(indexRepairedRemoteCommands.get(i));
        }
        repaired.add(this.repairCommand(indexRepairedRemoteCommands.get(commandCount - 1), UUID.randomUUID(), lastLocalCommand.getListVersionChange().getToVersion()));
        return repaired;
    }

    private ListCommand repairCommand(ListCommand toRepair, UUID fromVersion, UUID toVersion) {
        ListCommand.ListVersionChange change = new ListCommand.ListVersionChange(fromVersion, toVersion);
        if (toRepair instanceof AddToList) {
            AddToList orig = (AddToList)toRepair;
            return new AddToList(orig.getListId(), change, orig.getValue(), orig.getPosition());
        }
        if (toRepair instanceof RemoveFromList) {
            RemoveFromList orig = (RemoveFromList)toRepair;
            return new RemoveFromList(orig.getListId(), change, orig.getStartPosition(), orig.getRemoveCount());
        }
        if (toRepair instanceof ReplaceInList) {
            ReplaceInList orig = (ReplaceInList)toRepair;
            return new ReplaceInList(orig.getListId(), change, orig.getValue(), orig.getPosition());
        }
        throw new SynchronizeFXException(String.format("The executor does not know how to handle list commands of type '%s'.", toRepair.getClass()));
    }
}

