/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.Optional;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.AddToListRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.RemoveFromListRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ReplaceInListRepairer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ListCommandIndexRepairer {
    private final AddToListRepairer addToListRepairer;
    private final RemoveFromListRepairer removeFromListRepairer;
    private final ReplaceInListRepairer replaceInListRepairer;
    private Queue<ListCommand> localCommands;

    public ListCommandIndexRepairer(AddToListRepairer addToListRepairer, RemoveFromListRepairer removeFromListRepairer, ReplaceInListRepairer replaceInListRepairer) {
        this.addToListRepairer = addToListRepairer;
        this.removeFromListRepairer = removeFromListRepairer;
        this.replaceInListRepairer = replaceInListRepairer;
    }

    public List<? extends ListCommand> repairCommands(Queue<ListCommand> localCommands, ListCommand remoteCommand) {
        this.localCommands = localCommands;
        if (remoteCommand instanceof AddToList) {
            return this.repairCommands((AddToList)remoteCommand);
        }
        if (remoteCommand instanceof RemoveFromList) {
            return this.repairCommands((RemoveFromList)remoteCommand);
        }
        if (remoteCommand instanceof ReplaceInList) {
            return this.repairCommands((ReplaceInList)remoteCommand);
        }
        throw this.failUnknownTyp(remoteCommand);
    }

    private List<ListCommand> repairCommands(AddToList remoteCommand) {
        AddToList repaired = remoteCommand;
        int commandCount = this.localCommands.size();
        for (int i = 0; i < commandCount; ++i) {
            ListCommand localCommand = this.localCommands.poll();
            repaired = this.repairRemoteCommand(localCommand, repaired);
            if (localCommand instanceof AddToList) {
                this.localCommands.add(this.addToListRepairer.repairLocalCommand((AddToList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof RemoveFromList) {
                this.localCommands.addAll(this.removeFromListRepairer.repairCommand((RemoveFromList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof ReplaceInList) {
                this.localCommands.add(this.replaceInListRepairer.repairCommand((ReplaceInList)localCommand, remoteCommand));
                continue;
            }
            throw this.failUnknownTyp(remoteCommand);
        }
        ArrayList<ListCommand> list = new ArrayList<ListCommand>(1);
        list.add(repaired);
        return list;
    }

    private List<RemoveFromList> repairCommands(RemoveFromList remoteCommand) {
        List<RemoveFromList> repaired = Arrays.asList(remoteCommand);
        int commandCount = this.localCommands.size();
        for (int i = 0; i < commandCount; ++i) {
            ListCommand localCommand = this.localCommands.poll();
            List<RemoveFromList> repairedLastRound = repaired;
            repaired = new LinkedList<RemoveFromList>();
            for (RemoveFromList toRepair : repairedLastRound) {
                if (localCommand instanceof AddToList) {
                    repaired.addAll(this.removeFromListRepairer.repairCommand(toRepair, (AddToList)localCommand));
                    continue;
                }
                if (localCommand instanceof RemoveFromList) {
                    repaired.addAll(this.removeFromListRepairer.repairCommand(toRepair, (RemoveFromList)localCommand));
                    continue;
                }
                if (localCommand instanceof ReplaceInList) {
                    repaired.addAll(this.removeFromListRepairer.repairCommand(toRepair, (ReplaceInList)localCommand));
                    continue;
                }
                throw this.failUnknownTyp(remoteCommand);
            }
            if (localCommand instanceof AddToList) {
                this.localCommands.add(this.addToListRepairer.repairCommand((AddToList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof RemoveFromList) {
                this.localCommands.addAll(this.removeFromListRepairer.repairCommand((RemoveFromList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof ReplaceInList) {
                this.localCommands.add(this.replaceInListRepairer.repairCommand((ReplaceInList)localCommand, remoteCommand));
                continue;
            }
            throw this.failUnknownTyp(remoteCommand);
        }
        return repaired;
    }

    private List<ListCommand> repairCommands(ReplaceInList remoteCommand) {
        ListCommand repaired = remoteCommand;
        int commandCount = this.localCommands.size();
        for (int i = 0; i < commandCount; ++i) {
            ListCommand localCommand = this.localCommands.poll();
            repaired = repaired instanceof ReplaceInList ? this.repairRemoteCommand(localCommand, (ReplaceInList)repaired) : this.repairRemoteCommand(localCommand, (AddToList)repaired);
            if (localCommand instanceof AddToList) {
                this.localCommands.add(this.addToListRepairer.repairCommand((AddToList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof RemoveFromList) {
                this.localCommands.addAll(this.removeFromListRepairer.repairCommand((RemoveFromList)localCommand, remoteCommand));
                continue;
            }
            if (localCommand instanceof ReplaceInList) {
                Optional<ReplaceInList> repairedLocalCommand = this.replaceInListRepairer.repairLocalCommand((ReplaceInList)localCommand, remoteCommand);
                if (!repairedLocalCommand.isPresent()) continue;
                this.localCommands.add(repairedLocalCommand.get());
                continue;
            }
            throw this.failUnknownTyp(remoteCommand);
        }
        ArrayList<ListCommand> list = new ArrayList<ListCommand>(1);
        list.add(repaired);
        return list;
    }

    private AddToList repairRemoteCommand(ListCommand localCommand, AddToList remoteCommand) {
        if (localCommand instanceof AddToList) {
            return this.addToListRepairer.repairRemoteCommand(remoteCommand, (AddToList)localCommand);
        }
        if (localCommand instanceof RemoveFromList) {
            return this.addToListRepairer.repairCommand(remoteCommand, (RemoveFromList)localCommand);
        }
        if (localCommand instanceof ReplaceInList) {
            return this.addToListRepairer.repairCommand(remoteCommand, (ReplaceInList)localCommand);
        }
        throw this.failUnknownTyp(remoteCommand);
    }

    private ListCommand repairRemoteCommand(ListCommand localCommand, ReplaceInList remoteCommand) {
        if (localCommand instanceof AddToList) {
            return this.replaceInListRepairer.repairCommand(remoteCommand, (AddToList)localCommand);
        }
        if (localCommand instanceof RemoveFromList) {
            return this.replaceInListRepairer.repairCommand(remoteCommand, (RemoveFromList)localCommand);
        }
        if (localCommand instanceof ReplaceInList) {
            return this.replaceInListRepairer.repairRemoteCommand(remoteCommand, (ReplaceInList)localCommand);
        }
        throw this.failUnknownTyp(remoteCommand);
    }

    private SynchronizeFXException failUnknownTyp(ListCommand command) {
        throw new SynchronizeFXException(String.format("The executor does not know how to handle list commands of type '%s'.", command.getClass()));
    }
}

