/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors;

import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.executors.SimpleSingleValuePropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.SingleValuePropertyCommandExecutor;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javafx.beans.property.Property;
import org.apache.commons.collections.map.ReferenceIdentityMap;

public class RepairingSingleValuePropertyCommandExecutor
implements SingleValuePropertyCommandExecutor {
    private final WeakObjectRegistry objectRegistry;
    private final SimpleSingleValuePropertyCommandExecutor executor;
    private final Map<Property<Object>, Queue<UUID>> propertyToChangeLog = new ReferenceIdentityMap(2, 0);

    public RepairingSingleValuePropertyCommandExecutor(WeakObjectRegistry objectRegistry, SimpleSingleValuePropertyCommandExecutor executor) {
        this.objectRegistry = objectRegistry;
        this.executor = executor;
    }

    void logLocalCommand(SetPropertyValue command) {
        this.getLog(command).offer(command.getCommandId());
    }

    @Override
    public void execute(SetPropertyValue command) {
        Property property = (Property)this.objectRegistry.getByIdOrFail(command.getPropertyId());
        Queue<UUID> localCommands = this.propertyToChangeLog.get(property);
        if (localCommands != null && !localCommands.isEmpty()) {
            if (localCommands.peek().equals(command.getCommandId())) {
                localCommands.poll();
            }
            return;
        }
        this.executor.execute(command);
    }

    private Queue<UUID> getLog(SetPropertyValue command) {
        Property prop = (Property)this.objectRegistry.getByIdOrFail(command.getPropertyId());
        if (this.propertyToChangeLog.containsKey(prop)) {
            return this.propertyToChangeLog.get(prop);
        }
        LinkedList<UUID> log = new LinkedList<UUID>();
        this.propertyToChangeLog.put((Property<Object>)prop, log);
        return log;
    }
}

