/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.metamodel.Supplier;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TemporaryReferenceKeeper {
    private static final long REFERENCE_KEEPING_TIME = 60000L;
    private final List<HardReference> hardReferences = new LinkedList<HardReference>();
    private final Supplier<Date> currentDateSupplier;

    public TemporaryReferenceKeeper(Supplier<Date> currentDateSupplier) {
        this.currentDateSupplier = currentDateSupplier;
    }

    public void keepReferenceTo(Object object) {
        this.hardReferences.add(new HardReference(object, this.currentDateSupplier.get()));
    }

    public void cleanReferenceCache() {
        long now = this.currentDateSupplier.get().getTime();
        Iterator<HardReference> it = this.hardReferences.iterator();
        while (it.hasNext()) {
            if (it.next().keeptSince.getTime() + 60000L > now) continue;
            it.remove();
        }
    }

    Iterable<Object> getHardReferences() {
        ArrayList<Object> references = new ArrayList<Object>(this.hardReferences.size());
        for (HardReference reference : this.hardReferences) {
            references.add(reference.referenceToKeep);
        }
        return references;
    }

    private static class HardReference {
        private final Object referenceToKeep;
        private final Date keeptSince;

        HardReference(Object referenceToKeep, Date keeptSince) {
            this.referenceToKeep = referenceToKeep;
            this.keeptSince = keeptSince;
        }
    }
}

