/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandListCreator;
import de.saxsys.synchronizefx.core.metamodel.CommandListExecutor;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.ListPropertyMetaDataStore;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.ModelWalkingSynchronizer;
import de.saxsys.synchronizefx.core.metamodel.SilentChangeExecutor;
import de.saxsys.synchronizefx.core.metamodel.Supplier;
import de.saxsys.synchronizefx.core.metamodel.TemporaryReferenceKeeper;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import de.saxsys.synchronizefx.core.metamodel.executors.CommandLogDispatcher;
import de.saxsys.synchronizefx.core.metamodel.executors.RepairingSingleValuePropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.SimpleSingleValuePropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.AddToListRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListCommandIndexRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListCommandVersionRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListPropertyCommandFilter;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.RemoveFromListRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ReparingListPropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ReplaceInListRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.SimpleListPropertyCommandExecutor;
import java.util.Date;
import java.util.List;

public class MetaModel {
    private Object root;
    private TopologyLayerCallback topology;
    private CommandListCreator creator;
    private WeakObjectRegistry objectRegistry;
    private ValueMapper valueMapper;
    private SilentChangeExecutor silentChangeExecutor;
    private ModelWalkingSynchronizer modelWalkingSynchronizer;
    private ListPropertyMetaDataStore listMetaData;
    private SimpleListPropertyCommandExecutor simpleListCommandExecutor;
    private final CommandListExecutor executor;
    private final Listeners listeners;

    public MetaModel(TopologyLayerCallback topology) {
        this.initCommonObjects(topology);
        RepairingSingleValuePropertyCommandExecutor singleValuePropertyExecutor = new RepairingSingleValuePropertyCommandExecutor(this.objectRegistry, new SimpleSingleValuePropertyCommandExecutor(this.objectRegistry, this.silentChangeExecutor, this.valueMapper));
        ReparingListPropertyCommandExecutor repairingListExecutor = new ReparingListPropertyCommandExecutor(this.listMetaData, new ListCommandIndexRepairer(new AddToListRepairer(), new RemoveFromListRepairer(), new ReplaceInListRepairer()), new ListCommandVersionRepairer(), this.simpleListCommandExecutor, topology);
        CommandLogDispatcher commandLog = new CommandLogDispatcher(singleValuePropertyExecutor, repairingListExecutor);
        this.listeners = new Listeners(this.objectRegistry, this.creator, topology, this.modelWalkingSynchronizer, commandLog);
        this.silentChangeExecutor.registerListenersToSilence(this.listeners);
        TemporaryReferenceKeeper referenceKeeper = new TemporaryReferenceKeeper(new Supplier<Date>(){

            @Override
            public Date get() {
                return new Date();
            }
        });
        ListPropertyCommandFilter filteringListExecutor = new ListPropertyCommandFilter(repairingListExecutor, referenceKeeper, this.listMetaData, this.objectRegistry, false);
        this.executor = new CommandListExecutor(this, this.objectRegistry, this.listeners, this.silentChangeExecutor, this.valueMapper, this.listMetaData, singleValuePropertyExecutor, filteringListExecutor);
    }

    public MetaModel(TopologyLayerCallback topology, Object root) {
        this.initCommonObjects(topology);
        this.root = root;
        SimpleSingleValuePropertyCommandExecutor singleValuePropertyExecutor = new SimpleSingleValuePropertyCommandExecutor(this.objectRegistry, this.silentChangeExecutor, this.valueMapper);
        CommandLogDispatcher commandLog = new CommandLogDispatcher();
        this.listeners = new Listeners(this.objectRegistry, this.creator, topology, this.modelWalkingSynchronizer, commandLog);
        this.silentChangeExecutor.registerListenersToSilence(this.listeners);
        TemporaryReferenceKeeper referenceKeeper = new TemporaryReferenceKeeper(new Supplier<Date>(){

            @Override
            public Date get() {
                return new Date();
            }
        });
        ListPropertyCommandFilter filteringListExecutor = new ListPropertyCommandFilter(this.simpleListCommandExecutor, referenceKeeper, this.listMetaData, this.objectRegistry, true);
        this.executor = new CommandListExecutor(this, this.objectRegistry, this.listeners, this.silentChangeExecutor, this.valueMapper, this.listMetaData, singleValuePropertyExecutor, filteringListExecutor);
        this.registerListenersOnModel();
    }

    private void initCommonObjects(TopologyLayerCallback topology) {
        this.topology = topology;
        this.objectRegistry = new WeakObjectRegistry();
        this.valueMapper = new ValueMapper(this.objectRegistry);
        this.modelWalkingSynchronizer = new ModelWalkingSynchronizer();
        this.listMetaData = new ListPropertyMetaDataStore(this.objectRegistry);
        this.creator = new CommandListCreator(this.objectRegistry, this.valueMapper, topology, this.listMetaData);
        this.silentChangeExecutor = new SilentChangeExecutor();
        this.simpleListCommandExecutor = new SimpleListPropertyCommandExecutor(this.objectRegistry, this.silentChangeExecutor, this.valueMapper, this.listMetaData);
    }

    public void execute(final List<Command> commands) {
        try {
            this.modelWalkingSynchronizer.doWhenModelWalkerFinished(ModelWalkingSynchronizer.ActionType.INCOMMING_COMMANDS, new Runnable(){

                @Override
                public void run() {
                    for (Object command : commands) {
                        MetaModel.this.execute(command);
                    }
                }
            });
        }
        catch (SynchronizeFXException e) {
            this.topology.onError(e);
        }
    }

    public void commandsForDomainModel(CommandsForDomainModelCallback callback) {
        if (this.root == null) {
            this.topology.onError(new SynchronizeFXException("Request to create necessary commands to reproduce the domain model  but the root object of the domain model is not set."));
            return;
        }
        try {
            this.modelWalkingSynchronizer.startModelWalking();
            this.creator.commandsForDomainModel(this.root, callback);
            this.modelWalkingSynchronizer.finishedModelWalking();
        }
        catch (SynchronizeFXException e) {
            this.topology.onError(e);
        }
    }

    void setRoot(Object root) {
        this.root = root;
        this.topology.domainModelChanged(root);
    }

    ModelWalkingSynchronizer getModelWalkingSynchronizer() {
        return this.modelWalkingSynchronizer;
    }

    private void execute(Object command) {
        this.executor.execute(command);
    }

    private void registerListenersOnModel() {
        try {
            this.commandsForDomainModel(new CommandsForDomainModelCallback(){

                @Override
                public void commandsReady(List<Command> commands) {
                }
            });
            this.listeners.registerListenersOnEverything(this.root);
        }
        catch (SynchronizeFXException e) {
            this.topology.onError(e);
        }
    }
}

