/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.ObjectToIdMappingException;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.collections.map.ReferenceIdentityMap;

public class ListPropertyMetaDataStore {
    private final Map<List<?>, ListPropertyMetaData> listToData = new ReferenceIdentityMap(2, 0);
    private final WeakObjectRegistry objectRegistry;

    public ListPropertyMetaDataStore(WeakObjectRegistry objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public ListPropertyMetaData getMetaDataOrFail(List<?> list) {
        ListPropertyMetaData metaData = this.listToData.get(list);
        if (metaData == null) {
            throw new ObjectToIdMappingException("Meta data for an unknown property was requested. The clients may no longer be synchron.");
        }
        return metaData;
    }

    public ListPropertyMetaData getMetaDataOrFail(UUID listId) throws ObjectToIdMappingException {
        return this.getMetaDataOrFail((List)this.objectRegistry.getByIdOrFail(listId));
    }

    public void storeMetaDataOrFail(List<?> list, ListPropertyMetaData metaData) throws ObjectToIdMappingException {
        if (this.listToData.get(list) != null) {
            throw new ObjectToIdMappingException("Meta data for a known property should be registered twice. The clients may no longer be synchron.");
        }
        this.listToData.put(list, metaData);
    }

    public boolean hasMetaDataFor(List<?> list) {
        return this.listToData.containsKey(list);
    }

    public static class ListPropertyMetaData {
        private final LinkedList<ListCommand> unapprovedCommands = new LinkedList();
        private UUID localVersion;
        private UUID approvedVersion;

        public ListPropertyMetaData(UUID initialLocalVersion, UUID initialApprovedVersion) {
            this.localVersion = initialLocalVersion;
            this.approvedVersion = initialApprovedVersion;
        }

        public UUID getLocalVersion() {
            return this.localVersion;
        }

        public void setLocalVersion(UUID newVersion) {
            this.localVersion = newVersion;
        }

        public UUID getApprovedVersion() {
            return this.approvedVersion;
        }

        public void setApprovedVersion(UUID newVersion) {
            this.approvedVersion = newVersion;
        }

        public Queue<ListCommand> getUnapprovedCommands() {
            return this.unapprovedCommands;
        }

        public List<ListCommand> getUnapprovedCommandsAsList() {
            return this.unapprovedCommands;
        }

        public String toString() {
            return "ListPropertyMetaData [localVersion=" + this.localVersion + ", approvedVersion=" + this.approvedVersion + ", unapprovedCommands=" + this.unapprovedCommands + "]";
        }
    }
}

