/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandListCreator;
import de.saxsys.synchronizefx.core.metamodel.ListPropertyMetaDataStore;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.SilentChangeExecutor;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ClearReferences;
import de.saxsys.synchronizefx.core.metamodel.commands.CreateObservableObject;
import de.saxsys.synchronizefx.core.metamodel.commands.PutToMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.commands.SetRootElement;
import de.saxsys.synchronizefx.core.metamodel.executors.SingleValuePropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListPropertyCommandExecutor;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.beans.property.ListProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandListExecutor.class);
    private final MetaModel parent;
    private final WeakObjectRegistry objectRegistry;
    private final Listeners listeners;
    private final SilentChangeExecutor changeExecutor;
    private final ValueMapper valueMapper;
    private final ListPropertyMetaDataStore listPropertyMetaDataStore;
    private final SingleValuePropertyCommandExecutor singleValuePropertyExecutor;
    private final ListPropertyCommandExecutor listPropertyExecutor;
    private final Map<Object, Object> hardReferences = new IdentityHashMap<Object, Object>();

    public CommandListExecutor(MetaModel parent, WeakObjectRegistry objectRegistry, Listeners listeners, SilentChangeExecutor changeExecutor, ValueMapper valueMapper, ListPropertyMetaDataStore listPropertyMetaDataStore, SingleValuePropertyCommandExecutor singleValuePropertyExecutor, ListPropertyCommandExecutor listPropertyExecutor) {
        this.parent = parent;
        this.objectRegistry = objectRegistry;
        this.changeExecutor = changeExecutor;
        this.listeners = listeners;
        this.valueMapper = valueMapper;
        this.listPropertyMetaDataStore = listPropertyMetaDataStore;
        this.singleValuePropertyExecutor = singleValuePropertyExecutor;
        this.listPropertyExecutor = listPropertyExecutor;
    }

    public void execute(Object command) throws SynchronizeFXException {
        if (command instanceof CreateObservableObject) {
            this.execute((CreateObservableObject)command);
        } else if (command instanceof SetPropertyValue) {
            this.singleValuePropertyExecutor.execute((SetPropertyValue)command);
        } else if (command instanceof AddToList) {
            this.listPropertyExecutor.execute((AddToList)command);
        } else if (command instanceof RemoveFromList) {
            this.listPropertyExecutor.execute((RemoveFromList)command);
        } else if (command instanceof ReplaceInList) {
            this.listPropertyExecutor.execute((ReplaceInList)command);
        } else if (command instanceof PutToMap) {
            this.execute((PutToMap)command);
        } else if (command instanceof RemoveFromMap) {
            this.execute((RemoveFromMap)command);
        } else if (command instanceof AddToSet) {
            this.execute((AddToSet)command);
        } else if (command instanceof RemoveFromSet) {
            this.execute((RemoveFromSet)command);
        } else if (command instanceof ClearReferences) {
            this.hardReferences.clear();
        } else if (command instanceof SetRootElement) {
            this.execute((SetRootElement)command);
        } else {
            LOG.warn("Unknown command recived. Ignoring it");
        }
    }

    private void execute(CreateObservableObject command) {
        Object obj;
        try {
            Class<?> objClass = Class.forName(command.getClassName());
            obj = objClass.newInstance();
            this.listeners.registerListenersOnEverything(obj);
            for (Map.Entry<String, UUID> entry : command.getPropertyNameToId().entrySet()) {
                boolean fieldFound = false;
                for (Class<?> current = objClass; current != Object.class; current = current.getSuperclass()) {
                    try {
                        Field field = current.getDeclaredField(entry.getKey());
                        field.setAccessible(true);
                        this.registerInMetaModel(field.get(obj), entry.getValue());
                        fieldFound = true;
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                if (fieldFound) continue;
                throw new SynchronizeFXException("A command with a field name was recived which doesn't exist in the related class. Maybe you have different versions of the domain objects in your clients and the server?");
            }
        }
        catch (InstantiationException e) {
            throw new SynchronizeFXException("Maybe you've forgot to add a public no-arg constructor to one of your domain objects?", e);
        }
        catch (IllegalAccessException e) {
            throw new SynchronizeFXException("Maybe one of your no-arg constructor of one of your domain objects is not public?", e);
        }
        catch (ClassNotFoundException e) {
            throw new SynchronizeFXException("Maybe not all of you're domain objects or their dependencies are availabe on every node?", e);
        }
        catch (SecurityException e) {
            throw new SynchronizeFXException("Maybe you're JVM doesn't allow reflection for this application?", e);
        }
        this.hardReferences.put(obj, null);
        this.objectRegistry.registerObject(obj, command.getObjectId());
    }

    private void registerInMetaModel(Object object, UUID id) {
        List list;
        this.objectRegistry.registerObject(object, id);
        if (object instanceof ListProperty && !this.listPropertyMetaDataStore.hasMetaDataFor(list = (List)object)) {
            this.listPropertyMetaDataStore.storeMetaDataOrFail(list, new ListPropertyMetaDataStore.ListPropertyMetaData(CommandListCreator.INITIAL_LIST_VERSION, CommandListCreator.INITIAL_LIST_VERSION));
        }
    }

    private void execute(PutToMap command) {
        final Map map = (Map)this.objectRegistry.getByIdOrFail(command.getMapId());
        final Object key = this.valueMapper.map(command.getKey());
        final Object value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(map, new Runnable(){

            @Override
            public void run() {
                map.put(key, value);
            }
        });
    }

    private void execute(RemoveFromMap command) {
        final Map map = (Map)this.objectRegistry.getByIdOrFail(command.getMapId());
        final Object key = this.valueMapper.map(command.getKey());
        this.changeExecutor.execute(map, new Runnable(){

            @Override
            public void run() {
                map.remove(key);
            }
        });
    }

    private void execute(AddToSet command) {
        final Set set = (Set)this.objectRegistry.getByIdOrFail(command.getSetId());
        final Object value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(set, new Runnable(){

            @Override
            public void run() {
                set.add(value);
            }
        });
    }

    private void execute(RemoveFromSet command) {
        final Set set = (Set)this.objectRegistry.getByIdOrFail(command.getSetId());
        final Object value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(set, new Runnable(){

            @Override
            public void run() {
                set.remove(value);
            }
        });
    }

    private void execute(SetRootElement command) {
        Object root = this.objectRegistry.getByIdOrFail(command.getRootElementId());
        this.parent.setRoot(root);
    }
}

