/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.ListPropertyMetaDataStore;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.ListCommand;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListCommandIndexRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListCommandVersionRepairer;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.ListPropertyCommandExecutor;
import de.saxsys.synchronizefx.core.metamodel.executors.lists.SimpleListPropertyCommandExecutor;
import java.util.List;
import java.util.Queue;

public class ReparingListPropertyCommandExecutor
implements ListPropertyCommandExecutor {
    private final ListPropertyMetaDataStore listMetaDataStore;
    private final SimpleListPropertyCommandExecutor simpleExecutor;
    private final TopologyLayerCallback topologyLayerCallback;
    private final ListCommandIndexRepairer indexRepairer;
    private final ListCommandVersionRepairer versionRepairer;
    private ListPropertyMetaDataStore.ListPropertyMetaData metaData;

    public ReparingListPropertyCommandExecutor(ListPropertyMetaDataStore listMetaDataStore, ListCommandIndexRepairer indexRepairer, ListCommandVersionRepairer versionRepairer, SimpleListPropertyCommandExecutor simpleExecutor, TopologyLayerCallback topologyLayerCallback) {
        this.listMetaDataStore = listMetaDataStore;
        this.indexRepairer = indexRepairer;
        this.versionRepairer = versionRepairer;
        this.simpleExecutor = simpleExecutor;
        this.topologyLayerCallback = topologyLayerCallback;
    }

    @Override
    public void execute(AddToList command) {
        this.execute((ListCommand)command);
    }

    @Override
    public void execute(RemoveFromList command) {
        this.execute((ListCommand)command);
    }

    @Override
    public void execute(ReplaceInList command) {
        this.execute((ListCommand)command);
    }

    public void logLocalCommand(ListCommand localCommand) {
        this.getMetaData(localCommand);
        this.metaData.getUnapprovedCommands().offer(localCommand);
    }

    private void execute(ListCommand command) {
        this.getMetaData(command);
        Queue<ListCommand> log = this.metaData.getUnapprovedCommands();
        if (log.isEmpty()) {
            this.updateVersion(command);
            this.executeCommand(command);
        } else if (log.peek().getListVersionChange().equals(command.getListVersionChange())) {
            this.updateVersion(command);
            log.remove();
        } else {
            List<? extends ListCommand> repairedCommands = this.indexRepairer.repairCommands(this.metaData.getUnapprovedCommands(), command);
            this.versionRepairer.repairLocalCommandsVersion(this.metaData.getUnapprovedCommands(), command);
            repairedCommands = this.versionRepairer.repairRemoteCommandVersion(repairedCommands, this.metaData.getUnapprovedCommandsAsList());
            this.topologyLayerCallback.sendCommands(this.metaData.getUnapprovedCommandsAsList());
            for (ListCommand listCommand : repairedCommands) {
                this.executeCommand(listCommand);
            }
            this.updateVersion(command);
        }
    }

    private void getMetaData(ListCommand command) {
        this.metaData = this.listMetaDataStore.getMetaDataOrFail(command.getListId());
    }

    private void updateVersion(ListCommand command) {
        this.metaData.setApprovedVersion(command.getListVersionChange().getToVersion());
    }

    private void executeCommand(ListCommand command) {
        if (command instanceof AddToList) {
            this.simpleExecutor.execute((AddToList)command);
        } else if (command instanceof RemoveFromList) {
            this.simpleExecutor.execute((RemoveFromList)command);
        } else if (command instanceof ReplaceInList) {
            this.simpleExecutor.execute((ReplaceInList)command);
        } else {
            throw new SynchronizeFXException(String.format("The executor does not know how to handle list commands of type '%s'.", command.getClass()));
        }
    }
}

