/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel.executors.lists;

import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import java.util.Arrays;
import java.util.List;

public class RemoveFromListRepairer {
    public List<RemoveFromList> repairCommand(RemoveFromList toRepair, AddToList repairAgainst) {
        return this.repairAddOrReplace(toRepair, repairAgainst.getPosition());
    }

    public List<RemoveFromList> repairCommand(RemoveFromList toRepair, RemoveFromList repairAgainst) {
        if (toRepair.getStartPosition() + toRepair.getRemoveCount() <= repairAgainst.getStartPosition()) {
            return Arrays.asList(toRepair);
        }
        if (toRepair.getStartPosition() >= repairAgainst.getStartPosition() + repairAgainst.getRemoveCount()) {
            return Arrays.asList(this.createRepaired(toRepair, toRepair.getStartPosition() - repairAgainst.getRemoveCount(), toRepair.getRemoveCount()));
        }
        int startPosition = toRepair.getStartPosition() < repairAgainst.getStartPosition() ? toRepair.getStartPosition() : repairAgainst.getStartPosition();
        int indicesBefore = repairAgainst.getStartPosition() - toRepair.getStartPosition();
        int indicesAfter = toRepair.getStartPosition() + toRepair.getRemoveCount() - (repairAgainst.getStartPosition() + repairAgainst.getRemoveCount());
        int indicesBeforeAndAfter = Math.max(indicesBefore, 0) + Math.max(indicesAfter, 0);
        if (indicesBeforeAndAfter == 0) {
            return Arrays.asList(this.createRepaired(toRepair, 0, 0));
        }
        int removeCount = Math.min(indicesBeforeAndAfter, toRepair.getRemoveCount());
        return Arrays.asList(this.createRepaired(toRepair, startPosition, removeCount));
    }

    public List<RemoveFromList> repairCommand(RemoveFromList toRepair, ReplaceInList repairAgainst) {
        return this.repairAddOrReplace(toRepair, repairAgainst.getPosition());
    }

    private List<RemoveFromList> repairAddOrReplace(RemoveFromList toRepair, int position) {
        if (toRepair.getStartPosition() + toRepair.getRemoveCount() <= position) {
            return Arrays.asList(toRepair);
        }
        if (toRepair.getStartPosition() >= position) {
            return Arrays.asList(this.createRepaired(toRepair, toRepair.getStartPosition() + 1, toRepair.getRemoveCount()));
        }
        int removeCountBefore = position - toRepair.getStartPosition();
        int removeCountAfter = toRepair.getRemoveCount() - removeCountBefore;
        return Arrays.asList(this.createRepaired(toRepair, toRepair.getStartPosition(), removeCountBefore), this.createRepaired(toRepair, position + 1, removeCountAfter));
    }

    private RemoveFromList createRepaired(RemoveFromList toRepair, int startPosition, int removeCount) {
        return new RemoveFromList(toRepair.getListId(), toRepair.getListVersionChange(), startPosition, removeCount);
    }
}

