/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.ObjectToIdMappingException;
import de.saxsys.synchronizefx.core.metamodel.Optional;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.commons.collections.map.ReferenceMap;

public class WeakObjectRegistry {
    private static final String SYNCRONISM_LOST = "In most cases this means that synchronism with other peers has been lost.";
    private Map<Object, UUID> objectToId = new ReferenceIdentityMap(2, 0);
    private Map<UUID, Object> idToObject = new ReferenceMap(0, 2);

    public Optional<Object> getById(UUID id) {
        return Optional.ofNullable(this.idToObject.get(id));
    }

    public Object getByIdOrFail(UUID id) throws ObjectToIdMappingException {
        Optional<Object> object = this.getById(id);
        if (!object.isPresent()) {
            throw new ObjectToIdMappingException(String.format("An object with the id [%s] was expected to be known but it was not.  %s", id.toString(), SYNCRONISM_LOST));
        }
        return object.get();
    }

    public Optional<UUID> getId(Object object) {
        return Optional.ofNullable(this.objectToId.get(object));
    }

    public UUID getIdOrFail(Object object) throws ObjectToIdMappingException {
        Optional<UUID> id = this.getId(object);
        if (!id.isPresent()) {
            throw new ObjectToIdMappingException(String.format("An id for the object [%s] was expected to be known but it was not. %s", object.toString(), SYNCRONISM_LOST));
        }
        return id.get();
    }

    public UUID registerIfUnknown(Object object) {
        Optional<UUID> id = this.getId(object);
        if (!id.isPresent()) {
            return this.registerObject(object);
        }
        return id.get();
    }

    public void registerObject(Object object, UUID id) {
        this.objectToId.put(object, id);
        this.idToObject.put(id, object);
    }

    private UUID registerObject(Object object) {
        UUID id = UUID.randomUUID();
        this.registerObject(object, id);
        return id;
    }
}

