/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.ObjectToIdMappingException;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.Value;
import java.util.UUID;

public class ValueMapper {
    private final WeakObjectRegistry objectRegistry;

    public ValueMapper(WeakObjectRegistry objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public Object map(Value message) throws ObjectToIdMappingException {
        UUID valueId = message.getObservableObjectId();
        if (valueId != null) {
            return this.objectRegistry.getByIdOrFail(valueId);
        }
        return message.getSimpleObjectValue();
    }

    public Value map(Object value, boolean isObservable) throws ObjectToIdMappingException {
        if (isObservable) {
            return new Value(this.objectRegistry.getIdOrFail(value));
        }
        return new Value(value);
    }
}

