/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelWalkingSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ModelWalkingSynchronizer.class);
    private final Lock memberLock = new ReentrantLock();
    private final List<Set<CountDownLatch>> actionLocks = new ArrayList<Set<CountDownLatch>>(ActionType.values().length);
    private boolean modelWalkingInProgess;

    public ModelWalkingSynchronizer() {
        for (int i = 0; i < ActionType.values().length; ++i) {
            this.actionLocks.add(new HashSet());
        }
    }

    public void startModelWalking() {
        this.doWhenModelWalkerFinished(ActionType.MODEL_WALKNG, new Runnable(){

            @Override
            public void run() {
                ModelWalkingSynchronizer.this.memberLock.lock();
                ModelWalkingSynchronizer.this.modelWalkingInProgess = true;
                ModelWalkingSynchronizer.this.memberLock.unlock();
            }
        });
    }

    public void finishedModelWalking() {
        this.runNext();
    }

    public void doWhenModelWalkerFinished(ActionType type, Runnable action) {
        this.memberLock.lock();
        if (!this.modelWalkingInProgess) {
            this.memberLock.unlock();
            action.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        Set<CountDownLatch> latches = this.getLocksForAction(type);
        latches.add(latch);
        this.memberLock.unlock();
        this.awaitUninterupptetly(latch);
        action.run();
        this.memberLock.lock();
        latches.remove(latch);
        this.runNext();
        this.memberLock.unlock();
    }

    private void awaitUninterupptetly(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOG.warn("Waiting for model walking to finish was interuppted.");
            }
        }
    }

    private void runNext() {
        int actionTypeCount = ActionType.values().length;
        for (int nextType = 0; nextType < actionTypeCount; ++nextType) {
            Set<CountDownLatch> nextLocks = this.actionLocks.get(nextType);
            if (nextLocks.isEmpty()) continue;
            CountDownLatch next = nextLocks.iterator().next();
            next.countDown();
            return;
        }
        this.memberLock.lock();
        if (this.modelWalkingInProgess) {
            this.modelWalkingInProgess = false;
        }
        this.memberLock.unlock();
    }

    private Set<CountDownLatch> getLocksForAction(ActionType action) {
        return this.actionLocks.get(action.ordinal());
    }

    public static enum ActionType {
        LOCAL_PROPERTY_CHANGES,
        INCOMMING_COMMANDS,
        MODEL_WALKNG,
        TEST;

    }
}

