/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.ObjectToIdMappingException;
import de.saxsys.synchronizefx.core.metamodel.ObservedValue;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.Value;
import java.util.UUID;

class ValueMapper {
    private final WeakObjectRegistry objectRegistry;

    public ValueMapper(WeakObjectRegistry objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public ObservedValue map(Value message) throws ObjectToIdMappingException {
        ObservedValue value;
        UUID valueId = message.getObservableObjectId();
        if (valueId != null) {
            Object fromRegistry = this.objectRegistry.getByIdOrFail(valueId);
            value = new ObservedValue(fromRegistry, true);
        } else {
            value = new ObservedValue(message.getSimpleObjectValue(), false);
        }
        return value;
    }

    public Value map(ObservedValue value) throws ObjectToIdMappingException {
        Value msg = new Value();
        if (value.isObservable()) {
            UUID id = this.objectRegistry.getIdOrFail(value.getValue());
            msg.setObservableObjectId(id);
        } else {
            msg.setSimpleObjectValue(value.getValue());
        }
        return msg;
    }
}

