/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import java.util.NoSuchElementException;

final class Optional<T> {
    private final T value;

    private Optional(T value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("This optional has no value. Please use #isPresent() before calling #get().");
        }
        return this.value;
    }

    public static <T> Optional<T> empty() {
        return new Optional<Object>(null);
    }

    public static <T> Optional<T> of(T value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("A null value was passed which is not allowed to be null. Use #ofNullable(T) if the value can be null.");
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        return new Optional<T>(value);
    }
}

