/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandListCreator;
import de.saxsys.synchronizefx.core.metamodel.CommandListExecutor;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.ModelWalkingSynchronizer;
import de.saxsys.synchronizefx.core.metamodel.SilentChangeExecutor;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import java.util.List;
import java.util.concurrent.Executor;

public class MetaModel {
    private Object root;
    private final CommandListCreator creator;
    private final CommandListExecutor executor;
    private final Listeners listeners;
    private final ModelWalkingSynchronizer modelWalkingSynchronizer;
    private final TopologyLayerCallback topology;

    public MetaModel(TopologyLayerCallback topology, Executor changeExecutor) {
        this.topology = topology;
        WeakObjectRegistry objectRegistry = new WeakObjectRegistry();
        ValueMapper valueMapper = new ValueMapper(objectRegistry);
        this.modelWalkingSynchronizer = new ModelWalkingSynchronizer();
        this.creator = new CommandListCreator(objectRegistry, valueMapper, topology);
        this.listeners = new Listeners(objectRegistry, this.creator, topology, this.modelWalkingSynchronizer);
        SilentChangeExecutor silentChangeExecutor = new SilentChangeExecutor(this.listeners, changeExecutor);
        this.executor = new CommandListExecutor(this, objectRegistry, this.listeners, silentChangeExecutor, valueMapper);
    }

    public MetaModel(TopologyLayerCallback topology, Object root, Executor changeExecutor) {
        this(topology, changeExecutor);
        this.root = root;
        try {
            this.commandsForDomainModel(new CommandsForDomainModelCallback(){

                @Override
                public void commandsReady(List<Command> commands) {
                }
            });
            this.listeners.registerListenersOnEverything(root);
        }
        catch (SynchronizeFXException e) {
            topology.onError(e);
        }
    }

    public void execute(final List<Command> commands) {
        try {
            this.modelWalkingSynchronizer.doWhenModelWalkerFinished(ModelWalkingSynchronizer.ActionType.INCOMMING_COMMANDS, new Runnable(){

                @Override
                public void run() {
                    for (Object command : commands) {
                        MetaModel.this.execute(command);
                    }
                }
            });
        }
        catch (SynchronizeFXException e) {
            this.topology.onError(e);
        }
    }

    public void commandsForDomainModel(CommandsForDomainModelCallback callback) {
        if (this.root == null) {
            this.topology.onError(new SynchronizeFXException("Request to create necessary commands to reproduce the domain model  but the root object of the domain model is not set."));
            return;
        }
        try {
            this.modelWalkingSynchronizer.startModelWalking();
            this.creator.commandsForDomainModel(this.root, callback);
            this.modelWalkingSynchronizer.finishedModelWalking();
        }
        catch (SynchronizeFXException e) {
            this.topology.onError(e);
        }
    }

    void setRoot(Object root) {
        this.root = root;
        this.topology.domainModelChanged(root);
    }

    ModelWalkingSynchronizer getModelWalkingSynchronizer() {
        return this.modelWalkingSynchronizer;
    }

    private void execute(Object command) {
        this.executor.execute(command);
    }
}

