/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.ObservedValue;
import de.saxsys.synchronizefx.core.metamodel.SilentChangeExecutor;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ClearReferences;
import de.saxsys.synchronizefx.core.metamodel.commands.CreateObservableObject;
import de.saxsys.synchronizefx.core.metamodel.commands.PutToMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.commands.SetRootElement;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.beans.property.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandListExecutor.class);
    private final MetaModel parent;
    private final WeakObjectRegistry objectRegistry;
    private final Listeners listeners;
    private final SilentChangeExecutor changeExecutor;
    private final ValueMapper valueMapper;
    private final Map<Object, Object> hardReferences = new IdentityHashMap<Object, Object>();

    public CommandListExecutor(MetaModel parent, WeakObjectRegistry objectRegistry, Listeners listeners, SilentChangeExecutor changeExecutor, ValueMapper valueMapper) {
        this.parent = parent;
        this.objectRegistry = objectRegistry;
        this.changeExecutor = changeExecutor;
        this.listeners = listeners;
        this.valueMapper = valueMapper;
    }

    public void execute(Object command) throws SynchronizeFXException {
        if (command instanceof CreateObservableObject) {
            this.execute((CreateObservableObject)command);
        } else if (command instanceof SetPropertyValue) {
            this.execute((SetPropertyValue)command);
        } else if (command instanceof AddToList) {
            this.execute((AddToList)command);
        } else if (command instanceof RemoveFromList) {
            this.execute((RemoveFromList)command);
        } else if (command instanceof ReplaceInList) {
            this.execute((ReplaceInList)command);
        } else if (command instanceof PutToMap) {
            this.execute((PutToMap)command);
        } else if (command instanceof RemoveFromMap) {
            this.execute((RemoveFromMap)command);
        } else if (command instanceof AddToSet) {
            this.execute((AddToSet)command);
        } else if (command instanceof RemoveFromSet) {
            this.execute((RemoveFromSet)command);
        } else if (command instanceof ClearReferences) {
            this.hardReferences.clear();
        } else if (command instanceof SetRootElement) {
            this.execute((SetRootElement)command);
        } else {
            LOG.warn("Unknown command recived. Ignoring it");
        }
    }

    private void execute(CreateObservableObject command) {
        Object obj;
        try {
            Class<?> objClass = Class.forName(command.getClassName());
            obj = objClass.newInstance();
            this.listeners.registerListenersOnEverything(obj);
            for (Map.Entry<String, UUID> entry : command.getPropertyNameToId().entrySet()) {
                boolean fieldFound = false;
                for (Class<?> current = objClass; current != Object.class; current = current.getSuperclass()) {
                    try {
                        Field field = current.getDeclaredField(entry.getKey());
                        field.setAccessible(true);
                        this.objectRegistry.registerObject(field.get(obj), entry.getValue());
                        fieldFound = true;
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                if (fieldFound) continue;
                throw new SynchronizeFXException("A commadn with a field name was recived which doesn't exist in the related class. Maybe you have different versions of the domain objects in your clients and the server?");
            }
        }
        catch (InstantiationException e) {
            throw new SynchronizeFXException("Maybe you've forgot to add a public no-arg constructor to one of your domain objects?", e);
        }
        catch (IllegalAccessException e) {
            throw new SynchronizeFXException("Maybe one of your no-arg constructor of one of your domain objects is not public?", e);
        }
        catch (ClassNotFoundException e) {
            throw new SynchronizeFXException("Maybe not all of you're domain objects or their dependencies are availabe on every node?", e);
        }
        catch (SecurityException e) {
            throw new SynchronizeFXException("Maybe you're JVM doesn't allow reflection for this application?", e);
        }
        this.hardReferences.put(obj, null);
        this.objectRegistry.registerObject(obj, command.getObjectId());
    }

    private void execute(SetPropertyValue command) throws SynchronizeFXException {
        final Property prop = (Property)this.objectRegistry.getByIdOrFail(command.getPropertyId());
        final Object value = this.valueMapper.map(command.getValue()).getValue();
        this.changeExecutor.execute(prop, new Runnable(){

            @Override
            public void run() {
                prop.setValue(value);
            }
        });
    }

    private void execute(final AddToList command) {
        final List list = (List)this.objectRegistry.getByIdOrFail(command.getListId());
        final ObservedValue value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                if (list.size() >= command.getNewSize()) {
                    LOG.warn("Preconditions to apply AddToList command are not met. This may be OK if you've just connected.");
                    return;
                }
                list.add(command.getPosition(), value.getValue());
            }
        });
    }

    private void execute(final RemoveFromList command) {
        final List list = (List)this.objectRegistry.getByIdOrFail(command.getListId());
        this.changeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                if (list.size() <= command.getNewSize()) {
                    LOG.warn("Preconditions to apply RemoveFromList command are not met.This may be OK if you've just connected.");
                    return;
                }
                if (command.getStartPosition() == 0 && command.getRemoveCount() == list.size()) {
                    list.clear();
                } else {
                    for (int i = 0; i < command.getRemoveCount(); ++i) {
                        list.remove(command.getStartPosition());
                    }
                }
            }
        });
    }

    private void execute(final ReplaceInList command) {
        final List list = (List)this.objectRegistry.getByIdOrFail(command.getListId());
        final ObservedValue value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(list, new Runnable(){

            @Override
            public void run() {
                list.set(command.getPosition(), value.getValue());
            }
        });
    }

    private void execute(PutToMap command) {
        final Map map = (Map)this.objectRegistry.getByIdOrFail(command.getMapId());
        final ObservedValue key = this.valueMapper.map(command.getKey());
        final ObservedValue value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(map, new Runnable(){

            @Override
            public void run() {
                map.put(key.getValue(), value.getValue());
            }
        });
    }

    private void execute(RemoveFromMap command) {
        final Map map = (Map)this.objectRegistry.getByIdOrFail(command.getMapId());
        final ObservedValue key = this.valueMapper.map(command.getKey());
        this.changeExecutor.execute(map, new Runnable(){

            @Override
            public void run() {
                map.remove(key.getValue());
            }
        });
    }

    private void execute(AddToSet command) {
        final Set set = (Set)this.objectRegistry.getByIdOrFail(command.getSetId());
        final ObservedValue value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(set, new Runnable(){

            @Override
            public void run() {
                set.add(value.getValue());
            }
        });
    }

    private void execute(RemoveFromSet command) {
        final Set set = (Set)this.objectRegistry.getByIdOrFail(command.getSetId());
        final ObservedValue value = this.valueMapper.map(command.getValue());
        this.changeExecutor.execute(set, new Runnable(){

            @Override
            public void run() {
                set.remove(value.getValue());
            }
        });
    }

    private void execute(SetRootElement command) {
        Object root = this.objectRegistry.getByIdOrFail(command.getRootElementId());
        this.parent.setRoot(root);
    }
}

