/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.ObservedValue;
import de.saxsys.synchronizefx.core.metamodel.PropertyVisitor;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.ValueMapper;
import de.saxsys.synchronizefx.core.metamodel.WeakObjectRegistry;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ClearReferences;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import de.saxsys.synchronizefx.core.metamodel.commands.CreateObservableObject;
import de.saxsys.synchronizefx.core.metamodel.commands.PutToMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.commands.SetRootElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;

class CommandListCreator {
    private final WeakObjectRegistry objectRegistry;
    private final ValueMapper valueMapper;
    private final TopologyLayerCallback topology;

    public CommandListCreator(WeakObjectRegistry objectRegistry, ValueMapper valueMapper, TopologyLayerCallback topology) {
        this.objectRegistry = objectRegistry;
        this.valueMapper = valueMapper;
        this.topology = topology;
    }

    public void commandsForDomainModel(final Object root, CommandsForDomainModelCallback callback) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.createObservableObject(root, state);
            }
        }, false);
        SetRootElement msg = new SetRootElement();
        msg.setRootElementId(this.objectRegistry.getIdOrFail(root));
        state.commands.add(state.commands.size() - 1, msg);
        callback.commandsReady(state.commands);
    }

    public List<Command> setPropertyValue(final UUID propertyId, final Object value) throws SynchronizeFXException {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.setPropertyValue(propertyId, value, state);
            }
        }, true);
        return state.commands;
    }

    public List<Command> addToList(final UUID listId, final int position, final Object value, final int newSize) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.addToList(listId, position, value, newSize, state);
            }
        }, true);
        return state.commands;
    }

    public List<Command> addToSet(final UUID setId, final Object value) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.addToSet(setId, value, state);
            }
        }, true);
        return state.commands;
    }

    public List<Command> putToMap(final UUID mapId, final Object key, final Object value) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.putToMap(mapId, key, value, state);
            }
        }, true);
        return state.commands;
    }

    public List<Command> removeFromList(UUID listId, int startPosition, int removeCount, int newSize) {
        RemoveFromList msg = new RemoveFromList();
        msg.setListId(listId);
        msg.setStartPosition(startPosition);
        msg.setRemoveCount(removeCount);
        msg.setNewSize(newSize);
        ArrayList<Command> commands = new ArrayList<Command>(1);
        commands.add(msg);
        return commands;
    }

    public List<Command> removeFromMap(UUID mapId, final Object key) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.createObservableObject(key, state);
            }
        }, false);
        boolean keyIsObservableObject = state.lastObjectWasObservable;
        RemoveFromMap msg = new RemoveFromMap();
        msg.setMapId(mapId);
        msg.setKey(this.valueMapper.map(new ObservedValue(key, keyIsObservableObject)));
        state.commands.add(state.commands.size() - 1, msg);
        return state.commands;
    }

    public List<Command> removeFromSet(UUID setId, final Object value) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                CommandListCreator.this.createObservableObject(value, state);
            }
        }, false);
        boolean keyIsObservableObject = state.lastObjectWasObservable;
        RemoveFromSet msg = new RemoveFromSet();
        msg.setSetId(setId);
        msg.setValue(this.valueMapper.map(new ObservedValue(value, keyIsObservableObject)));
        state.commands.add(state.commands.size() - 1, msg);
        return state.commands;
    }

    public List<Command> replaceInList(final UUID listId, final int position, final Object value) {
        State state = this.createCommandList(new WithCommandType(){

            @Override
            public void invoke(State state) {
                ReplaceInList replaceInList = new ReplaceInList();
                replaceInList.setListId(listId);
                replaceInList.setPosition(position);
                boolean isObservableObject = CommandListCreator.this.createObservableObject(value, state);
                replaceInList.setValue(CommandListCreator.this.valueMapper.map(new ObservedValue(value, isObservableObject)));
                state.commands.add(replaceInList);
            }
        }, true);
        return state.commands;
    }

    private void setPropertyValue(UUID propertyId, Object value, State state) {
        SetPropertyValue msg = new SetPropertyValue();
        msg.setPropertyId(propertyId);
        boolean isObservableObject = this.createObservableObject(value, state);
        msg.setValue(this.valueMapper.map(new ObservedValue(value, isObservableObject)));
        state.commands.add(msg);
    }

    private void addToList(UUID listId, int position, Object value, int newSize, State state) {
        AddToList msg = new AddToList();
        msg.setListId(listId);
        msg.setPosition(position);
        msg.setNewSize(newSize);
        boolean isObservableObject = this.createObservableObject(value, state);
        msg.setValue(this.valueMapper.map(new ObservedValue(value, isObservableObject)));
        state.commands.add(msg);
    }

    private void addToSet(UUID setId, Object value, State state) {
        AddToSet msg = new AddToSet();
        msg.setSetId(setId);
        boolean isObservableObject = this.createObservableObject(value, state);
        msg.setValue(this.valueMapper.map(new ObservedValue(value, isObservableObject)));
        state.commands.add(msg);
    }

    private void putToMap(UUID mapId, Object key, Object value, State state) {
        PutToMap msg = new PutToMap();
        msg.setMapId(mapId);
        boolean keyIsObservableObject = this.createObservableObject(key, state);
        boolean valueIsObservableObject = this.createObservableObject(value, state);
        msg.setKey(this.valueMapper.map(new ObservedValue(key, keyIsObservableObject)));
        msg.setValue(this.valueMapper.map(new ObservedValue(value, valueIsObservableObject)));
        state.commands.add(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createObservableObject(final Object value, final State state) {
        if (value == null || !PropertyVisitor.isObservableObject(value.getClass())) {
            return state.lastObjectWasObservable = false;
        }
        Map map = state.alreadyVisited;
        synchronized (map) {
            if (state.alreadyVisited.containsKey(value)) {
                return state.lastObjectWasObservable = true;
            }
            state.alreadyVisited.put(value, null);
        }
        if (state.skipKnown && this.objectRegistry.getId(value).isPresent()) {
            return state.lastObjectWasObservable = true;
        }
        final CreateObservableObject msg = new CreateObservableObject();
        int currentSize = state.commands.size();
        try {
            new PropertyVisitor(value){

                @Override
                protected boolean visitSingleValueProperty(Property<?> fieldValue) {
                    UUID fieldId = this.registerPropertyAndParent(this.getCurrentField(), fieldValue);
                    CommandListCreator.this.setPropertyValue(fieldId, fieldValue.getValue(), state);
                    return false;
                }

                @Override
                protected boolean visitCollectionProperty(ListProperty<?> fieldValue) {
                    UUID fieldId = this.registerPropertyAndParent(this.getCurrentField(), (Property<?>)fieldValue);
                    ListIterator it = fieldValue.listIterator();
                    int index = 0;
                    while (it.hasNext()) {
                        Object o = it.next();
                        CommandListCreator.this.addToList(fieldId, index, o, index + 1, state);
                        ++index;
                    }
                    return false;
                }

                @Override
                protected boolean visitCollectionProperty(MapProperty<?, ?> fieldValue) {
                    UUID fieldId = this.registerPropertyAndParent(this.getCurrentField(), (Property<?>)fieldValue);
                    for (Map.Entry entry : fieldValue.entrySet()) {
                        CommandListCreator.this.putToMap(fieldId, entry.getKey(), entry.getValue(), state);
                    }
                    return false;
                }

                @Override
                protected boolean visitCollectionProperty(SetProperty<?> fieldValue) {
                    UUID fieldId = this.registerPropertyAndParent(this.getCurrentField(), (Property<?>)fieldValue);
                    for (Object entry : fieldValue) {
                        CommandListCreator.this.addToSet(fieldId, entry, state);
                    }
                    return false;
                }

                private UUID registerPropertyAndParent(Field field, Property<?> fieldValue) {
                    msg.setObjectId(CommandListCreator.this.objectRegistry.registerIfUnknown(value));
                    UUID fieldId = CommandListCreator.this.objectRegistry.registerIfUnknown(fieldValue);
                    msg.getPropertyNameToId().put(field.getName(), fieldId);
                    return fieldId;
                }
            };
        }
        catch (IllegalAccessException e) {
            this.topology.onError(new SynchronizeFXException(e));
        }
        catch (SecurityException e) {
            this.topology.onError(new SynchronizeFXException("Maybe you're JVM doesn't allow reflection for this application?", e));
        }
        if (msg.getObjectId() == null) {
            return state.lastObjectWasObservable = false;
        }
        msg.setClassName(value.getClass().getName());
        state.commands.add(currentSize, msg);
        return state.lastObjectWasObservable = true;
    }

    private State createCommandList(WithCommandType type, boolean skipKnown) {
        State state = new State(skipKnown);
        boolean restart = true;
        while (restart) {
            restart = false;
            state.reset();
            try {
                type.invoke(state);
            }
            catch (ConcurrentModificationException e) {
                restart = true;
            }
        }
        state.commands.add(new ClearReferences());
        return state;
    }

    private static interface WithCommandType {
        public void invoke(State var1);
    }

    private static class State {
        private final Map<Object, Object> alreadyVisited = new IdentityHashMap<Object, Object>();
        private final List<Command> commands = new LinkedList<Command>();
        private final boolean skipKnown;
        private boolean lastObjectWasObservable;

        public State(boolean skipKnown) {
            this.skipKnown = skipKnown;
        }

        public void reset() {
            this.alreadyVisited.clear();
            this.commands.clear();
            this.lastObjectWasObservable = false;
        }
    }
}

