/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.clientserver;

import de.saxsys.synchronizefx.core.clientserver.CommandTransferServer;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackServer;
import de.saxsys.synchronizefx.core.clientserver.ServerCallback;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainModelServer
implements NetworkToTopologyCallbackServer,
TopologyLayerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(DomainModelServer.class);
    private final CommandTransferServer networkLayer;
    private final MetaModel meta;
    private final ServerCallback serverCallback;

    public DomainModelServer(Object model, CommandTransferServer networkLayer, ServerCallback serverCallback) {
        this(model, networkLayer, serverCallback, new DirectExecutor());
    }

    public DomainModelServer(Object model, CommandTransferServer networkLayer, ServerCallback serverCallback, Executor changeExecutor) {
        this.networkLayer = networkLayer;
        this.serverCallback = serverCallback;
        this.meta = new MetaModel(this, model, changeExecutor);
        networkLayer.setTopologyLayerCallback(this);
    }

    @Override
    public void recive(List<Command> commands, Object sender) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Server recived commands " + commands);
        }
        this.meta.execute(commands);
        this.networkLayer.sendToAllExcept(commands, sender);
    }

    @Override
    public void sendCommands(List<Command> commands) {
        this.networkLayer.sendToAll(commands);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Server sent commands " + commands);
        }
    }

    @Override
    public void onError(SynchronizeFXException error) {
        this.serverCallback.onError(error);
    }

    @Override
    public void domainModelChanged(Object root) {
        this.serverCallback.onError(new SynchronizeFXException("Domain model has changed on the server side. This is not supported. If you want to serve a new domain model, consider creating an a new Server or create a meta root that holds the real root object of your domain model wich than can be exchanged without problems."));
    }

    @Override
    public void onConnect(final Object newClient) {
        this.meta.commandsForDomainModel(new CommandsForDomainModelCallback(){

            @Override
            public void commandsReady(List<Command> commands) {
                DomainModelServer.this.networkLayer.onConnectFinished(newClient);
                DomainModelServer.this.networkLayer.send(commands, newClient);
            }
        });
    }

    @Override
    public void onClientConnectionError(SynchronizeFXException e) {
        LOG.warn("Client disconnected unexpectetly", (Throwable)e);
    }

    @Override
    public void onFatalError(SynchronizeFXException e) {
        this.serverCallback.onError(e);
    }

    public void start() {
        try {
            this.networkLayer.start();
        }
        catch (SynchronizeFXException e) {
            this.serverCallback.onError(e);
        }
    }

    public void shutdown() {
        this.networkLayer.shutdown();
    }

    private static class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable change) {
            change.run();
        }
    }
}

