/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.clientserver;

import de.saxsys.synchronizefx.core.clientserver.ClientCallback;
import de.saxsys.synchronizefx.core.clientserver.CommandTransferClient;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackClient;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import java.util.List;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainModelClient
implements NetworkToTopologyCallbackClient,
TopologyLayerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(DomainModelClient.class);
    private final ClientCallback clientCallback;
    private final MetaModel meta;
    private final CommandTransferClient networkLayer;
    private final Executor changeExecutor;

    public DomainModelClient(CommandTransferClient networkLayer, ClientCallback clientCallback) {
        this(networkLayer, clientCallback, new ExecuteInJavaFXThread());
    }

    public DomainModelClient(CommandTransferClient networkLayer, ClientCallback clientCallback, Executor changeExecutor) {
        this.clientCallback = clientCallback;
        this.networkLayer = networkLayer;
        this.changeExecutor = changeExecutor;
        networkLayer.setTopologyCallback(this);
        this.meta = new MetaModel(this, changeExecutor);
    }

    @Override
    public void recive(List<Command> commands) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Client recived commands " + commands);
        }
        this.meta.execute(commands);
    }

    @Override
    public void sendCommands(List<Command> commands) {
        this.networkLayer.send(commands);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Client sent commands " + commands);
        }
    }

    @Override
    public void onError(SynchronizeFXException error) {
        this.clientCallback.onError(error);
    }

    @Override
    public void onServerDisconnect() {
        this.clientCallback.onServerDisconnect();
    }

    @Override
    public void domainModelChanged(final Object root) {
        this.changeExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DomainModelClient.this.clientCallback.modelReady(root);
            }
        });
    }

    public void connect() {
        try {
            this.networkLayer.connect();
        }
        catch (SynchronizeFXException e) {
            this.clientCallback.onError(e);
        }
    }

    public void disconnect() {
        this.networkLayer.disconnect();
    }

    private static class ExecuteInJavaFXThread
    implements Executor {
        private ExecuteInJavaFXThread() {
        }

        @Override
        public void execute(Runnable change) {
            Platform.runLater((Runnable)change);
        }
    }
}

