/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;

abstract class PropertyVisitor {
    private static Set<Class<?>> simpleObjects = Collections.synchronizedSet(new HashSet());
    private final Map<Object, Object> alreadyVisited = new IdentityHashMap<Object, Object>();
    private Field currentField;
    private Deque<Object> currentObservableObject = new LinkedList<Object>();
    private Deque<Parent> parent = new LinkedList<Parent>();

    PropertyVisitor(Object object) throws IllegalAccessException, SecurityException {
        this.parent.push(new Parent(null, null, null, null));
        this.visit(object);
    }

    protected void visitObservableObjectStart() {
    }

    protected void visitObservableObjectEnd() {
    }

    protected void visitSimpleObject(Object object) {
    }

    protected abstract boolean visitCollectionProperty(ListProperty<?> var1);

    protected abstract boolean visitCollectionProperty(MapProperty<?, ?> var1);

    protected abstract boolean visitCollectionProperty(SetProperty<?> var1);

    protected abstract boolean visitSingleValueProperty(Property<?> var1);

    public Field getCurrentField() {
        return this.currentField;
    }

    public Object getCurrentObservableObject() {
        return this.currentObservableObject.peek();
    }

    public ListProperty<?> getParentList() {
        return this.parent.peek().parentList;
    }

    public SetProperty<?> getParentSet() {
        return this.parent.peek().parentSet;
    }

    public MapProperty<?, ?> getParentMap() {
        return this.parent.peek().parentMap;
    }

    public Property<?> getParentProperty() {
        return this.parent.peek().parentProperty;
    }

    private void visit(Object object) throws IllegalAccessException {
        if (object == null) {
            return;
        }
        if (simpleObjects.contains(object.getClass())) {
            this.visitSimpleObject(object);
            return;
        }
        if (this.alreadyVisited.containsKey(object)) {
            this.startVisiting(object);
            this.stopVisiting();
            return;
        }
        boolean isObservableObject = this.visitFields(object);
        if (isObservableObject) {
            this.stopVisiting();
        } else {
            this.visitSimpleObject(object);
            simpleObjects.add(object.getClass());
        }
    }

    private boolean visitFields(Object object) throws IllegalAccessException {
        boolean isObservableObject = false;
        for (Field field : this.getInheritedFields(object.getClass())) {
            field.setAccessible(true);
            this.currentField = field;
            Class<?> fieldClass = field.getType();
            if (!isObservableObject && this.classImplements(fieldClass, Property.class)) {
                this.startVisiting(object);
                isObservableObject = true;
            }
            if (fieldClass == ListProperty.class) {
                this.handle((ListProperty)field.get(object));
                continue;
            }
            if (fieldClass == SetProperty.class) {
                this.handle((SetProperty)field.get(object));
                continue;
            }
            if (fieldClass == MapProperty.class) {
                this.handle((MapProperty)field.get(object));
                continue;
            }
            if (!this.classImplements(fieldClass, Property.class)) continue;
            this.handle((Property)field.get(object));
        }
        return isObservableObject;
    }

    private void startVisiting(Object object) {
        this.alreadyVisited.put(object, null);
        this.currentObservableObject.push(object);
        this.visitObservableObjectStart();
    }

    private void stopVisiting() {
        this.visitObservableObjectEnd();
        this.currentObservableObject.pop();
    }

    private void handle(ListProperty<?> property) throws IllegalAccessException {
        if (this.visitCollectionProperty(property)) {
            ListIterator it = property.listIterator();
            while (it.hasNext()) {
                this.visit(it.next());
            }
        }
    }

    private void handle(SetProperty<?> property) throws IllegalAccessException {
        if (this.visitCollectionProperty(property)) {
            for (Object child : property) {
                this.visit(child);
            }
        }
    }

    private void handle(MapProperty<?, ?> property) throws IllegalAccessException {
        if (this.visitCollectionProperty(property)) {
            for (Map.Entry entry : property.entrySet()) {
                this.visit(entry.getKey());
                this.visit(entry.getValue());
            }
        }
    }

    private void handle(Property<?> property) throws IllegalAccessException {
        if (this.visitSingleValueProperty(property)) {
            Object value = property.getValue();
            this.visit(value);
        }
    }

    private List<Field> getInheritedFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private boolean classImplements(Class<?> is, Class<?> should) {
        for (Class<?> clazz : is.getInterfaces()) {
            if (clazz.equals(should)) {
                return true;
            }
            if (!this.classImplements(clazz, should)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObservableObject(Class<?> clazz) {
        return !simpleObjects.contains(clazz);
    }

    private static final class Parent {
        private final ListProperty<?> parentList;
        private final SetProperty<?> parentSet;
        private final MapProperty<?, ?> parentMap;
        private final Property<?> parentProperty;

        Parent(Property<?> parentProperty, ListProperty<?> parentList, SetProperty<?> parentSet, MapProperty<?, ?> parentMap) {
            this.parentList = parentList;
            this.parentSet = parentSet;
            this.parentMap = parentMap;
            this.parentProperty = parentProperty;
        }
    }
}

