/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandListCreator;
import de.saxsys.synchronizefx.core.metamodel.CommandListExecutor;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.commons.collections.map.ReferenceMap;

public class MetaModel {
    private Map<Object, UUID> objectToId = new ReferenceIdentityMap(2, 0);
    private Map<UUID, Object> idToObject = new ReferenceMap(0, 2);
    private CommandListCreator creator;
    private CommandListExecutor executor;
    private Listeners listeners;
    private boolean doChangesInJavaFxThread = false;
    private Object root;
    private TopologyLayerCallback topology;
    private final Object modelWalkingInProgressLock = new Object();
    private boolean modelWalkingInProgress;

    public MetaModel(TopologyLayerCallback topology) {
        this.topology = topology;
        this.creator = new CommandListCreator(this, topology);
        this.listeners = new Listeners(this, this.creator, topology);
        this.executor = new CommandListExecutor(this, this.listeners, topology);
    }

    public MetaModel(TopologyLayerCallback topology, Object root) {
        this(topology);
        this.root = root;
        this.commandsForDomainModel(new CommandsForDomainModelCallback(){

            @Override
            public void commandsReady(List<Object> commands) {
            }
        });
        this.listeners.registerListenersOnEverything(root);
    }

    public boolean isDoChangesInJavaFxThread() {
        return this.doChangesInJavaFxThread;
    }

    public void setDoChangesInJavaFxThread(boolean doChangesInJavaFxThread) {
        this.doChangesInJavaFxThread = doChangesInJavaFxThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(List<Object> commands) {
        Object object = this.modelWalkingInProgressLock;
        synchronized (object) {
            for (Object message : commands) {
                this.execute(message);
            }
        }
    }

    public void commandsForDomainModel(CommandsForDomainModelCallback callback) {
        if (this.root == null) {
            this.topology.onError(new SynchronizeFXException("Request to create necessary commands to reproduce the domain model  but the root object of the domain model is not set."));
            return;
        }
        this.creator.commandsForDomainModel(this.root, callback);
    }

    public Object getById(UUID id) {
        return this.idToObject.get(id);
    }

    public UUID getId(Object object) {
        return this.objectToId.get(object);
    }

    void setRoot(Object root) {
        this.root = root;
        this.topology.domainModelChanged(root);
    }

    UUID registerIfUnknown(Object object) {
        UUID id = this.getId(object);
        if (id == null) {
            id = this.registerObject(object);
        }
        return id;
    }

    void registerObject(Object object, UUID id) {
        this.objectToId.put(object, id);
        this.idToObject.put(id, object);
    }

    Object getModelWalkingInProgressLock() {
        return this.modelWalkingInProgressLock;
    }

    boolean isModelWalkingInProgress() {
        return this.modelWalkingInProgress;
    }

    void setModelWalkingInProgress(boolean modelWalkingInProgress) {
        this.modelWalkingInProgress = modelWalkingInProgress;
    }

    private void execute(Object command) {
        this.executor.execute(command);
    }

    private UUID registerObject(Object object) {
        UUID id = this.generateId();
        this.registerObject(object, id);
        return id;
    }

    private UUID generateId() {
        return UUID.randomUUID();
    }
}

