/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandListCreator;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.PropertyVisitor;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.collections.WeakMapChangeListener;
import javafx.collections.WeakSetChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Listeners
implements ChangeListener<Object>,
ListChangeListener<Object>,
SetChangeListener<Object>,
MapChangeListener<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Listeners.class);
    private final MetaModel parent;
    private final CommandListCreator creator;
    private final TopologyLayerCallback topology;
    private final WeakChangeListener<Object> propertyListener = new WeakChangeListener((ChangeListener)this);
    private final WeakListChangeListener<Object> listListener = new WeakListChangeListener((ListChangeListener)this);
    private final WeakSetChangeListener<Object> setListener = new WeakSetChangeListener((SetChangeListener)this);
    private final WeakMapChangeListener<Object, Object> mapListener = new WeakMapChangeListener((MapChangeListener)this);
    private final Map<Object, Object> disabledFor = new IdentityHashMap<Object, Object>();

    public Listeners(MetaModel parent, CommandListCreator creator, TopologyLayerCallback topology) {
        this.parent = parent;
        this.creator = creator;
        this.topology = topology;
    }

    public void registerListenersOnEverything(Object object) {
        try {
            new PropertyVisitor(object){

                @Override
                protected boolean visitSingleValueProperty(Property<?> fieldValue) {
                    fieldValue.removeListener((ChangeListener)Listeners.this.propertyListener);
                    fieldValue.addListener((ChangeListener)Listeners.this.propertyListener);
                    return true;
                }

                @Override
                protected boolean visitCollectionProperty(ListProperty<?> fieldValue) {
                    fieldValue.removeListener((ListChangeListener)Listeners.this.listListener);
                    fieldValue.addListener((ListChangeListener)Listeners.this.listListener);
                    return true;
                }

                @Override
                protected boolean visitCollectionProperty(MapProperty<?, ?> fieldValue) {
                    fieldValue.removeListener((MapChangeListener)Listeners.this.mapListener);
                    fieldValue.addListener((MapChangeListener)Listeners.this.mapListener);
                    return true;
                }

                @Override
                protected boolean visitCollectionProperty(SetProperty<?> fieldValue) {
                    fieldValue.removeListener((SetChangeListener)Listeners.this.setListener);
                    fieldValue.addListener((SetChangeListener)Listeners.this.setListener);
                    return false;
                }
            };
        }
        catch (IllegalAccessException e) {
            this.topology.onError(new SynchronizeFXException(e));
        }
        catch (SecurityException e) {
            this.topology.onError(new SynchronizeFXException("Maybe you're JVM doesn't allow reflection for this application?", e));
        }
    }

    public void registerOn(Property<?> prop) {
        prop.addListener(this.propertyListener);
    }

    public void registerOn(ListProperty<?> list) {
        list.addListener(this.listListener);
    }

    public void registerOn(MapProperty<?, ?> map) {
        map.addListener(this.mapListener);
    }

    public void changed(ObservableValue<? extends Object> property, Object oldValue, Object newValue) {
        if (this.disabledFor.containsKey(property)) {
            return;
        }
        List<Object> commands = this.creator.setPropertyValue(this.parent.getId(property), newValue);
        if (newValue != null) {
            this.registerListenersOnEverything(newValue);
        }
        this.distributeCommands(commands);
    }

    public void onChanged(ListChangeListener.Change<? extends Object> event) {
        ObservableList list = event.getList();
        if (this.disabledFor.containsKey(list)) {
            return;
        }
        event.reset();
        UUID listId = this.parent.getId(list);
        while (event.next()) {
            List<Object> commands = null;
            if (event.wasPermutated()) {
                LOG.warn("Got an ListChangeListener.Change event that permutates the list. This case is not implemented and is not synchronized.");
            } else if (event.wasUpdated()) {
                LOG.warn("Got an ListChangeListener.Change event that indicates that some elements in a list have been updated. This case is not implemented and is not synchronized.");
            } else if (event.wasAdded()) {
                if (event.wasRemoved()) {
                    LOG.warn("BUG: An add and remove operation can be in the same event. That case is not handled by the software");
                }
                commands = new LinkedList();
                for (int i = event.getFrom(); i < event.getTo(); ++i) {
                    Object elem = list.get(i);
                    UUID id = this.parent.getId(elem);
                    commands.addAll(this.creator.addToList(listId, i, elem, list.size()));
                    if (elem == null || id != null) continue;
                    this.registerListenersOnEverything(elem);
                }
            } else if (event.wasRemoved()) {
                if (event.getFrom() != event.getTo()) {
                    LOG.warn("BUG: A remove operation in a list change event can remove more than one items. That case is not handled by the software");
                }
                commands = this.creator.removeFromList(listId, event.getTo(), list.size());
            }
            if (commands == null) continue;
            this.distributeCommands(commands);
        }
        event.reset();
    }

    public void onChanged(SetChangeListener.Change<? extends Object> change) {
        ObservableSet set = change.getSet();
        if (this.disabledFor.containsKey(set)) {
            return;
        }
        UUID setId = this.parent.getId(set);
        List<Object> commands = null;
        if (change.wasAdded()) {
            Object value = change.getElementAdded();
            commands = this.creator.addToSet(setId, value);
            this.registerListenersOnEverything(value);
        } else {
            Object value = change.getElementRemoved();
            commands = this.creator.removeFromSet(setId, value);
        }
        this.distributeCommands(commands);
    }

    public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
        ObservableMap map = change.getMap();
        if (this.disabledFor.containsKey(map)) {
            return;
        }
        UUID mapId = this.parent.getId(map);
        Object key = change.getKey();
        if (change.wasAdded()) {
            Object value = change.getValueAdded();
            List<Object> commands = this.creator.putToMap(mapId, key, value);
            this.registerListenersOnEverything(key);
            if (value != null) {
                this.registerListenersOnEverything(value);
            }
            this.distributeCommands(commands);
        } else {
            this.distributeCommands(this.creator.removeFromMap(mapId, key));
        }
    }

    public void disableFor(Object value) {
        this.disabledFor.put(value, null);
    }

    public void enableFor(Object value) {
        this.disabledFor.remove(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeCommands(List<Object> commands) {
        Object object = this.parent.getModelWalkingInProgressLock();
        synchronized (object) {
            while (this.parent.isModelWalkingInProgress()) {
                try {
                    this.parent.getModelWalkingInProgressLock().wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("User thread that was blocked by SynchronizeFX was woken up by an Exception.", (Throwable)e);
                }
            }
        }
        this.topology.sendCommands(commands);
    }
}

