/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.metamodel;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.Listeners;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToSet;
import de.saxsys.synchronizefx.core.metamodel.commands.ClearReferences;
import de.saxsys.synchronizefx.core.metamodel.commands.CreateObservableObject;
import de.saxsys.synchronizefx.core.metamodel.commands.PutToMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromMap;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromSet;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.commands.SetRootElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.property.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandListExecutor.class);
    private final MetaModel parent;
    private final Listeners listeners;
    private final Map<Object, Object> hardReferences = new IdentityHashMap<Object, Object>();
    private Map<Property<?>, Field> propFieldMap;
    private final TopologyLayerCallback topology;

    public CommandListExecutor(MetaModel parent, Listeners listeners, TopologyLayerCallback topology) {
        this.topology = topology;
        this.parent = parent;
        this.listeners = listeners;
        if (LOG.isTraceEnabled()) {
            this.propFieldMap = new HashMap();
        }
    }

    public void execute(Object command) {
        this.sleepUntilModelWalkerFinish();
        if (command instanceof CreateObservableObject) {
            this.execute((CreateObservableObject)command);
        } else if (command instanceof SetPropertyValue) {
            this.execute((SetPropertyValue)command);
        } else if (command instanceof AddToList) {
            this.execute((AddToList)command);
        } else if (command instanceof RemoveFromList) {
            this.execute((RemoveFromList)command);
        } else if (command instanceof PutToMap) {
            this.execute((PutToMap)command);
        } else if (command instanceof RemoveFromMap) {
            this.execute((RemoveFromMap)command);
        } else if (command instanceof AddToSet) {
            this.execute((AddToSet)command);
        } else if (command instanceof RemoveFromSet) {
            this.execute((RemoveFromSet)command);
        } else if (command instanceof ClearReferences) {
            this.hardReferences.clear();
        } else if (command instanceof SetRootElement) {
            this.execute((SetRootElement)command);
        } else {
            LOG.warn("Unknown message recived. Ignoring it");
        }
    }

    private void execute(CreateObservableObject command) {
        Object obj;
        try {
            Class<?> objClass = Class.forName(command.getClassName());
            obj = objClass.newInstance();
            this.listeners.registerListenersOnEverything(obj);
            for (Map.Entry<String, UUID> entry : command.getPropertyNameToId().entrySet()) {
                boolean fieldFound = false;
                for (Class<?> current = objClass; current != Object.class; current = current.getSuperclass()) {
                    try {
                        Field field = current.getDeclaredField(entry.getKey());
                        field.setAccessible(true);
                        this.parent.registerObject(field.get(obj), entry.getValue());
                        fieldFound = true;
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                if (fieldFound) continue;
                this.topology.onError(new SynchronizeFXException("A message with a field name was recived which doesn't exist in the related class. Maybe you have different versions of the domain objects in your clients and the server?"));
            }
        }
        catch (InstantiationException e) {
            this.topology.onError(new SynchronizeFXException("Maybe you've forgot to add a public no-arg constructor to one of your domain objects?", e));
            return;
        }
        catch (IllegalAccessException e) {
            this.topology.onError(new SynchronizeFXException("Maybe one of your no-arg constructor of one of your domain objects is not public?", e));
            return;
        }
        catch (ClassNotFoundException e) {
            this.topology.onError(new SynchronizeFXException("Maybe not all of you're domain objects or their dependencies are availabe on every node?", e));
            return;
        }
        catch (SecurityException e) {
            this.topology.onError(new SynchronizeFXException("Maybe you're JVM doesn't allow reflection for this application?", e));
            return;
        }
        this.hardReferences.put(obj, null);
        this.parent.registerObject(obj, command.getObjectId());
    }

    private void execute(SetPropertyValue command) {
        Object value;
        UUID valueId;
        final Property prop = (Property)this.parent.getById(command.getPropertyId());
        if (prop == null) {
            this.topology.onError(new SynchronizeFXException("SetPropertyValue with unknown property id recived. " + command.getPropertyId()));
            return;
        }
        if (LOG.isTraceEnabled()) {
            Field field = this.propFieldMap.get(prop);
            if (field != null) {
                LOG.trace("Set on field " + field + " value " + command);
            } else {
                LOG.trace(command.toString());
            }
        }
        if ((valueId = command.getObservableObjectId()) != null) {
            value = this.parent.getById(valueId);
            if (value == null) {
                this.topology.onError(new SynchronizeFXException("SetPropertyValue command with unknown value object id recived. " + command.getObservableObjectId()));
                return;
            }
        } else {
            value = command.getSimpleObjectValue();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(prop);
                prop.setValue(value);
                CommandListExecutor.this.listeners.enableFor(prop);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(final AddToList command) {
        Object value;
        UUID valueId;
        final List list = (List)this.parent.getById(command.getListId());
        if (list == null) {
            this.topology.onError(new SynchronizeFXException("AddToList command with unknown list id recived. " + command.getListId()));
            return;
        }
        if (LOG.isTraceEnabled()) {
            Field field = this.propFieldMap.get(list);
            if (field != null) {
                LOG.trace("Add to list " + field + " value " + command);
            } else {
                LOG.trace(command.toString());
            }
        }
        if ((valueId = command.getObservableObjectId()) != null) {
            value = this.parent.getById(valueId);
            if (value == null) {
                this.topology.onError(new SynchronizeFXException("AddToList command unknown with value object id recived. " + command.getObservableObjectId()));
                return;
            }
        } else {
            value = command.getSimpleObjectValue();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(list);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Add value {} to list {} at position {}.", new Object[]{value, Arrays.toString(list.toArray()), command.getPosition()});
                }
                if (list.size() >= command.getNewSize()) {
                    LOG.warn("Preconditions to apply AddToList command are not met. This may be OK if you've just connected.");
                    return;
                }
                list.add(command.getPosition(), value);
                CommandListExecutor.this.listeners.enableFor(list);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(final RemoveFromList command) {
        final List list = (List)this.parent.getById(command.getListId());
        if (LOG.isTraceEnabled()) {
            Field field = this.propFieldMap.get(list);
            if (field != null) {
                LOG.trace("Remove from list " + field + " value " + command);
            } else {
                LOG.trace(command.toString());
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(list);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Remove from list {} at position {}.", (Object)Arrays.toString(list.toArray()), (Object)command.getPosition());
                }
                if (list.size() <= command.getNewSize()) {
                    LOG.warn("Preconditions to apply RemoveFromList command are not met.This may be OK if you've just connected.");
                    return;
                }
                list.remove(command.getPosition());
                CommandListExecutor.this.listeners.enableFor(list);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(PutToMap command) {
        Object value;
        UUID valueId;
        Object key;
        UUID keyId;
        final Map map = (Map)this.parent.getById(command.getMapId());
        if (map == null) {
            this.topology.onError(new SynchronizeFXException("PutToMap command with unknown map id recived. " + command.getMapId()));
            return;
        }
        if (LOG.isTraceEnabled()) {
            Field field = this.propFieldMap.get(map);
            if (field != null) {
                LOG.trace("Put in map " + field + " value " + command);
            } else {
                LOG.trace(command.toString());
            }
        }
        if ((keyId = command.getKeyObservableObjectId()) != null) {
            key = this.parent.getById(keyId);
            if (key == null) {
                this.topology.onError(new SynchronizeFXException("PutToMap command with unknown key object id recived. " + command.getKeyObservableObjectId()));
                return;
            }
        } else {
            key = command.getKeySimpleObjectValue();
        }
        if ((valueId = command.getValueObservableObjectId()) != null) {
            value = this.parent.getById(valueId);
            if (value == null) {
                this.topology.onError(new SynchronizeFXException("PutToMap command with unknown value object id recived. " + command.getValueObservableObjectId()));
                return;
            }
        } else {
            value = command.getValueSimpleObjectValue();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(map);
                map.put(key, value);
                CommandListExecutor.this.listeners.enableFor(map);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(RemoveFromMap command) {
        Object key;
        final Map map = (Map)this.parent.getById(command.getMapId());
        Object object = key = command.getKeySimpleObjectValue() != null ? command.getKeySimpleObjectValue() : this.parent.getById(command.getKeyObservableObjectId());
        if (key == null) {
            this.topology.onError(new SynchronizeFXException("RemoveFromMap command with unknown key object id recived. " + command.getKeySimpleObjectValue()));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(map);
                map.remove(key);
                CommandListExecutor.this.listeners.enableFor(map);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(AddToSet command) {
        Object value;
        final Set set = (Set)this.parent.getById(command.getListId());
        if (set == null) {
            this.topology.onError(new SynchronizeFXException("AddToSet command with unknown list id recived. " + command.getListId()));
            return;
        }
        UUID valueId = command.getObservableObjectId();
        if (valueId != null) {
            value = this.parent.getById(valueId);
            if (value == null) {
                this.topology.onError(new SynchronizeFXException("AddToSet command unknown with value object id recived. " + command.getObservableObjectId()));
                return;
            }
        } else {
            value = command.getSimpleObjectValue();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(set);
                set.add(value);
                CommandListExecutor.this.listeners.enableFor(set);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(RemoveFromSet command) {
        Object value;
        final Set set = (Set)this.parent.getById(command.getListId());
        Object object = value = command.getSimpleObjectValue() != null ? command.getSimpleObjectValue() : this.parent.getById(command.getObservableObjectId());
        if (value == null) {
            this.topology.onError(new SynchronizeFXException("RemoveFromSet command with unknown value object id recived. " + command.getSimpleObjectValue()));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListExecutor.this.listeners.disableFor(set);
                set.remove(value);
                CommandListExecutor.this.listeners.enableFor(set);
            }
        };
        if (this.parent.isDoChangesInJavaFxThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void execute(SetRootElement command) {
        Object root = this.parent.getById(command.getRootElementId());
        this.parent.setRoot(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepUntilModelWalkerFinish() {
        Object object = this.parent.getModelWalkingInProgressLock();
        synchronized (object) {
            while (this.parent.isModelWalkingInProgress()) {
                try {
                    this.parent.getModelWalkingInProgressLock().wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("User thread that was blocked by SynchronizeFX was woken up by an Exception.", (Throwable)e);
                }
            }
        }
    }
}

