/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.clientserver;

import de.saxsys.synchronizefx.core.clientserver.MessageTransferServer;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackServer;
import de.saxsys.synchronizefx.core.clientserver.ServerCallback;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.CommandsForDomainModelCallback;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainModelServer
implements NetworkToTopologyCallbackServer,
TopologyLayerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(DomainModelServer.class);
    private MessageTransferServer networkLayer;
    private MetaModel meta;
    private ServerCallback serverCallback;

    public DomainModelServer(Object model, MessageTransferServer networkLayer, ServerCallback serverCallback) {
        this.networkLayer = networkLayer;
        this.serverCallback = serverCallback;
        this.meta = new MetaModel(this, model);
        networkLayer.setTopologyLayerCallback(this);
    }

    @Override
    public void recive(List<Object> messages, Object sender) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Server recived commands " + messages);
        }
        this.meta.execute(messages);
        this.networkLayer.sendToAllExcept(messages, sender);
    }

    @Override
    public void sendCommands(List<Object> commands) {
        this.networkLayer.sendToAll(commands);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Server sent commands " + commands);
        }
    }

    @Override
    public void onError(SynchronizeFXException error) {
        this.serverCallback.onError(error);
    }

    @Override
    public void domainModelChanged(Object root) {
        this.serverCallback.onError(new SynchronizeFXException("Domain model has changed on the server side. This is not supported. If you want to serve a new domain model, consider creating an a new Server or create a meta root that holds the real root object of your domain model wich than can be exchanged without problems."));
    }

    @Override
    public void onConnect(final Object newClient) {
        this.meta.commandsForDomainModel(new CommandsForDomainModelCallback(){

            @Override
            public void commandsReady(List<Object> commands) {
                DomainModelServer.this.networkLayer.onConnectFinished(newClient);
                DomainModelServer.this.networkLayer.send(commands, newClient);
            }
        });
    }

    @Override
    public void onClientConnectionError(SynchronizeFXException e) {
        LOG.warn("Client disconnected unexpectetly", (Throwable)e);
    }

    @Override
    public void onFatalError(SynchronizeFXException e) {
        this.serverCallback.onError(e);
    }

    public void start() {
        try {
            this.networkLayer.start();
        }
        catch (SynchronizeFXException e) {
            this.serverCallback.onError(e);
        }
    }

    public void shutdown() {
        this.networkLayer.shutdown();
    }
}

