/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.core.clientserver;

import de.saxsys.synchronizefx.core.clientserver.ClientCallback;
import de.saxsys.synchronizefx.core.clientserver.MessageTransferClient;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackClient;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.MetaModel;
import de.saxsys.synchronizefx.core.metamodel.TopologyLayerCallback;
import java.util.List;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainModelClient
implements NetworkToTopologyCallbackClient,
TopologyLayerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(DomainModelClient.class);
    private ClientCallback clientCallback;
    private MetaModel meta = new MetaModel(this);
    private MessageTransferClient networkLayer;

    public DomainModelClient(MessageTransferClient networkLayer, ClientCallback clientCallback) {
        this.clientCallback = clientCallback;
        this.networkLayer = networkLayer;
        networkLayer.setTopologyCallback(this);
    }

    @Override
    public void recive(List<Object> messages) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Client recived commands " + messages);
        }
        this.meta.execute(messages);
    }

    @Override
    public void sendCommands(List<Object> commands) {
        this.networkLayer.send(commands);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Client sent commands " + commands);
        }
    }

    @Override
    public void onError(SynchronizeFXException error) {
        this.clientCallback.onError(error);
    }

    @Override
    public void onServerDisconnect() {
        this.clientCallback.onServerDisconnect();
    }

    @Override
    public void domainModelChanged(final Object root) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DomainModelClient.this.clientCallback.modelReady(root);
            }
        });
        this.meta.setDoChangesInJavaFxThread(true);
    }

    public void connect() {
        try {
            this.networkLayer.connect();
        }
        catch (SynchronizeFXException e) {
            this.clientCallback.onError(e);
        }
    }

    public void disconnect() {
        this.networkLayer.disconnect();
    }
}

