/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.websockets;

import de.saxsys.synchronizefx.netty.base.Codec;
import de.saxsys.synchronizefx.netty.websockets.ByteBufToWebSocketFrameCodec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.Map;

class WebsocketChannelInitializer
implements Codec {
    private static final String PROTOCOL = "v1.websocket.synchronizefx.saxsys.de";
    private final URI serverUri;
    private final Map<String, Object> httpHeaders;

    public WebsocketChannelInitializer(URI serverUri, Map<String, Object> httpHeaders) {
        this.serverUri = serverUri;
        this.httpHeaders = httpHeaders;
    }

    @Override
    public void addToPipeline(ChannelPipeline pipeline) {
        pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192));
        pipeline.addLast("websocket-protocol-handler", (ChannelHandler)new WebSocketClientProtocolHandler(this.serverUri, WebSocketVersion.V13, PROTOCOL, false, this.createHttpHeaders(this.httpHeaders), Integer.MAX_VALUE));
        pipeline.addLast("websocket-frame-codec", (ChannelHandler)new ByteBufToWebSocketFrameCodec());
    }

    private HttpHeaders createHttpHeaders(Map<String, Object> headerParams) {
        if (headerParams == null || headerParams.isEmpty()) {
            return null;
        }
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        for (Map.Entry<String, Object> headerEntry : headerParams.entrySet()) {
            headers.add(headerEntry.getKey(), headerEntry.getValue());
        }
        return headers;
    }
}

