/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.websockets;

import de.saxsys.synchronizefx.core.clientserver.Serializer;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.netty.base.client.BasicChannelInitializerClient;
import de.saxsys.synchronizefx.netty.base.client.NettyBasicClient;
import de.saxsys.synchronizefx.netty.websockets.WebsocketChannelInitializer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class NettyWebsocketClient
extends NettyBasicClient {
    private final URI serverUri;
    private final Serializer serializer;
    private final Map<String, Object> httpHeaders;
    private final boolean useSsl;

    public NettyWebsocketClient(URI serverUri, Serializer serializer) {
        this(serverUri, serializer, null);
    }

    public NettyWebsocketClient(URI serverUri, Serializer serializer, Map<String, Object> httpHeaders) {
        super(new InetSocketAddress(serverUri.getHost(), serverUri.getPort()));
        this.serverUri = serverUri;
        this.serializer = serializer;
        this.httpHeaders = new HashMap<String, Object>(httpHeaders);
        this.useSsl = this.uriRequiresSslOrFail();
    }

    @Override
    protected BasicChannelInitializerClient createChannelInitializer() {
        WebsocketChannelInitializer codec = new WebsocketChannelInitializer(this.serverUri, this.httpHeaders);
        return new BasicChannelInitializerClient(this.serializer, codec, this.useSsl);
    }

    private boolean uriRequiresSslOrFail() throws SynchronizeFXException {
        String protocol = this.serverUri.getScheme();
        if ("ws".equals(protocol)) {
            return false;
        }
        if ("wss".equals(protocol)) {
            return true;
        }
        throw new SynchronizeFXException((Throwable)new IllegalArgumentException("The protocol of the uri is not Websocket."));
    }
}

