/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.websockets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteBufToWebSocketFrameCodec
extends MessageToMessageCodec<WebSocketFrame, ByteBuf> {
    private static final ByteBuf[] BYTE_BUF_TYPE = new ByteBuf[0];
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufToWebSocketFrameCodec.class);
    private final List<ByteBuf> fragments = new LinkedList<ByteBuf>();

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(new BinaryWebSocketFrame(msg));
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        if (msg instanceof BinaryWebSocketFrame) {
            ByteBuf content = msg.content();
            content.retain();
            this.fragments.add(content);
            if (msg.isFinalFragment()) {
                if (this.fragments.size() == 1) {
                    out.add(this.fragments.get(0));
                } else {
                    ByteBuf[] array = this.fragments.toArray(BYTE_BUF_TYPE);
                    out.add(Unpooled.wrappedBuffer((ByteBuf[])array));
                }
                this.fragments.clear();
            }
        } else if (msg instanceof TextWebSocketFrame) {
            LOG.warn("Recieved a Websocket text frame. This was not expected. Ignoring it.");
        }
    }
}

