/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.server;

import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackServer;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkEventHandlerServer
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkEventHandlerServer.class);
    private final NetworkToTopologyCallbackServer userCallback;

    public NetworkEventHandlerServer(NetworkToTopologyCallbackServer userCallback) {
        this.userCallback = userCallback;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("A client connected from the address " + ctx.channel().remoteAddress());
        this.userCallback.onConnect((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("The connection to client with the address" + ctx.channel().remoteAddress() + " was closed.");
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String message = "An error occured when communicating with the client at address " + ctx.channel().remoteAddress() + ". Closing the connection to this client.";
        LOG.warn(message, cause);
        ctx.channel().close();
        this.userCallback.onClientConnectionError(new SynchronizeFXException(message, cause));
    }

    public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        promise.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    NetworkEventHandlerServer.this.exceptionCaught(ctx, cause);
                }
            }
        });
        ctx.write(msg, promise);
    }
}

