/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.server;

import de.saxsys.synchronizefx.core.clientserver.CommandTransferServer;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackServer;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import de.saxsys.synchronizefx.netty.base.server.BasicChannelInitializerServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.List;

public abstract class NettyBasicServer
implements CommandTransferServer {
    private NioEventLoopGroup connectionAccptorGroup;
    private NioEventLoopGroup clientConnectionGroup;
    private ChannelGroup clients = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final int port;
    private NetworkToTopologyCallbackServer callback;

    public NettyBasicServer(int port) {
        this.port = port;
    }

    protected abstract BasicChannelInitializerServer createChannelInitializer();

    public void start() throws SynchronizeFXException {
        this.connectionAccptorGroup = new NioEventLoopGroup();
        this.clientConnectionGroup = new NioEventLoopGroup();
        BasicChannelInitializerServer channelInitializer = this.createChannelInitializer();
        channelInitializer.setTopologyCallback(this.callback);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group((EventLoopGroup)this.connectionAccptorGroup, (EventLoopGroup)this.clientConnectionGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)channelInitializer).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.bind(this.port).syncUninterruptibly();
    }

    public void setTopologyLayerCallback(NetworkToTopologyCallbackServer callback) {
        this.callback = callback;
    }

    public void onConnectFinished(Object client) {
        this.clients.add((Object)((Channel)client));
    }

    public void sendToAll(List<Command> commands) {
        this.clients.writeAndFlush(commands);
    }

    public void send(List<Command> commands, Object client) {
        ((Channel)client).writeAndFlush(commands);
    }

    public void sendToAllExcept(List<Command> commands, final Object nonReciver) {
        this.clients.writeAndFlush(commands, new ChannelMatcher(){

            public boolean matches(Channel candidate) {
                return candidate != nonReciver;
            }
        });
    }

    public void shutdown() {
        this.connectionAccptorGroup.shutdownGracefully().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

            public void operationComplete(Future<Object> future) throws Exception {
                NettyBasicServer.this.clientConnectionGroup.shutdownGracefully();
            }
        });
    }
}

