/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.server;

import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackServer;
import de.saxsys.synchronizefx.core.clientserver.Serializer;
import de.saxsys.synchronizefx.netty.base.Codec;
import de.saxsys.synchronizefx.netty.base.CommandToBinaryByteBuf;
import de.saxsys.synchronizefx.netty.base.NonValidatingSSLEngineFactory;
import de.saxsys.synchronizefx.netty.base.server.InboundCommandHandlerServer;
import de.saxsys.synchronizefx.netty.base.server.NetworkEventHandlerServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;

public class BasicChannelInitializerServer
extends ChannelInitializer<SocketChannel> {
    private final Serializer serializer;
    private final Codec codec;
    private final boolean useSSL;
    private NetworkToTopologyCallbackServer userCallback;

    public BasicChannelInitializerServer(Serializer serializer, Codec codec, boolean useSSL) {
        this.serializer = serializer;
        this.codec = codec;
        this.useSSL = useSSL;
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.useSSL) {
            pipeline.addLast("tls", (ChannelHandler)NonValidatingSSLEngineFactory.createSslHandler(false));
        }
        this.codec.addToPipeline(pipeline);
        pipeline.addLast("message-to-command", (ChannelHandler)new CommandToBinaryByteBuf(this.serializer));
        pipeline.addLast("command-handler", (ChannelHandler)new InboundCommandHandlerServer(this.userCallback));
        pipeline.addLast("event-handler", (ChannelHandler)new NetworkEventHandlerServer(this.userCallback));
    }

    void setTopologyCallback(NetworkToTopologyCallbackServer callback) {
        this.userCallback = callback;
    }
}

